package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.Marker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTapeArchivesResponse(
    tapeArchives: Option[Iterable[zio.aws.storagegateway.model.TapeArchive]] =
      None,
    marker: Option[Marker] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse = {
    import DescribeTapeArchivesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse
      .builder()
      .optionallyWith(
        tapeArchives.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tapeArchives)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly =
    zio.aws.storagegateway.model.DescribeTapeArchivesResponse
      .wrap(buildAwsValue())
}
object DescribeTapeArchivesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DescribeTapeArchivesResponse =
      zio.aws.storagegateway.model.DescribeTapeArchivesResponse(
        tapeArchives.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def tapeArchives
        : Option[List[zio.aws.storagegateway.model.TapeArchive.ReadOnly]]
    def marker: Option[Marker]
    def getTapeArchives: ZIO[Any, AwsError, List[
      zio.aws.storagegateway.model.TapeArchive.ReadOnly
    ]] = AwsError.unwrapOptionField("tapeArchives", tapeArchives)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse
  ) extends zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly {
    override val tapeArchives
        : Option[List[zio.aws.storagegateway.model.TapeArchive.ReadOnly]] =
      scala
        .Option(impl.tapeArchives())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.TapeArchive.wrap(item)
          }.toList
        )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.storagegateway.model.primitives.Marker(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DescribeTapeArchivesResponse
  ): zio.aws.storagegateway.model.DescribeTapeArchivesResponse.ReadOnly =
    new Wrapper(impl)
}
