package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.FileSystemAssociationARN
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisassociateFileSystemRequest(
    fileSystemAssociationARN: FileSystemAssociationARN,
    forceDelete: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest = {
    import DisassociateFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest
      .builder()
      .fileSystemAssociationARN(
        FileSystemAssociationARN.unwrap(
          fileSystemAssociationARN
        ): java.lang.String
      )
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.DisassociateFileSystemRequest.ReadOnly =
    zio.aws.storagegateway.model.DisassociateFileSystemRequest
      .wrap(buildAwsValue())
}
object DisassociateFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.storagegateway.model.DisassociateFileSystemRequest =
      zio.aws.storagegateway.model.DisassociateFileSystemRequest(
        fileSystemAssociationARN,
        forceDelete.map(value => value)
      )
    def fileSystemAssociationARN: FileSystemAssociationARN
    def forceDelete: Option[Boolean]
    def getFileSystemAssociationARN
        : ZIO[Any, Nothing, FileSystemAssociationARN] =
      ZIO.succeed(fileSystemAssociationARN)
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest
  ) extends zio.aws.storagegateway.model.DisassociateFileSystemRequest.ReadOnly {
    override val fileSystemAssociationARN: FileSystemAssociationARN =
      zio.aws.storagegateway.model.primitives
        .FileSystemAssociationARN(impl.fileSystemAssociationARN())
    override val forceDelete: Option[Boolean] =
      scala.Option(impl.forceDelete()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.DisassociateFileSystemRequest
  ): zio.aws.storagegateway.model.DisassociateFileSystemRequest.ReadOnly =
    new Wrapper(impl)
}
