package zio.aws.storagegateway.model
import zio.aws.storagegateway.model.primitives.{SnapshotDescription, VolumeARN}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotFromVolumeRecoveryPointRequest(
    volumeARN: VolumeARN,
    snapshotDescription: SnapshotDescription,
    tags: Option[Iterable[zio.aws.storagegateway.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest = {
    import CreateSnapshotFromVolumeRecoveryPointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
      .builder()
      .volumeARN(VolumeARN.unwrap(volumeARN): java.lang.String)
      .snapshotDescription(
        SnapshotDescription.unwrap(snapshotDescription): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest.ReadOnly =
    zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
      .wrap(buildAwsValue())
}
object CreateSnapshotFromVolumeRecoveryPointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest =
      zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest(
        volumeARN,
        snapshotDescription,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def volumeARN: VolumeARN
    def snapshotDescription: SnapshotDescription
    def tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]]
    def getVolumeARN: ZIO[Any, Nothing, VolumeARN] = ZIO.succeed(volumeARN)
    def getSnapshotDescription: ZIO[Any, Nothing, SnapshotDescription] =
      ZIO.succeed(snapshotDescription)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
  ) extends zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest.ReadOnly {
    override val volumeARN: VolumeARN =
      zio.aws.storagegateway.model.primitives.VolumeARN(impl.volumeARN())
    override val snapshotDescription: SnapshotDescription =
      zio.aws.storagegateway.model.primitives
        .SnapshotDescription(impl.snapshotDescription())
    override val tags: Option[List[zio.aws.storagegateway.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.storagegateway.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest
  ): zio.aws.storagegateway.model.CreateSnapshotFromVolumeRecoveryPointRequest.ReadOnly =
    new Wrapper(impl)
}
