package zio.aws.ssooidc
import zio.aws.ssooidc.model.CreateTokenResponse.ReadOnly
import zio.aws.core.AwsError
import software.amazon.awssdk.services.ssooidc.SsoOidcAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ssooidc.model.{
  StartDeviceAuthorizationRequest,
  RegisterClientRequest,
  CreateTokenRequest
}
import zio.test.mock.{Proxy, Mock}
object SsoOidcMock extends Mock[SsoOidc] {
  object CreateToken extends Effect[CreateTokenRequest, AwsError, ReadOnly]
  object RegisterClient
      extends Effect[
        RegisterClientRequest,
        AwsError,
        zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly
      ]
  object StartDeviceAuthorization
      extends Effect[
        StartDeviceAuthorizationRequest,
        AwsError,
        zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SsoOidc] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new SsoOidc {
          val api: SsoOidcAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : SsoOidc = this
          def createToken(request: CreateTokenRequest): IO[AwsError, ReadOnly] =
            proxy(CreateToken, request)
          def registerClient(request: RegisterClientRequest): IO[
            AwsError,
            zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly
          ] = proxy(RegisterClient, request)
          def startDeviceAuthorization(
              request: StartDeviceAuthorizationRequest
          ): IO[
            AwsError,
            zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly
          ] = proxy(StartDeviceAuthorization, request)
        }
      }
    }
    .toLayer
}
