package zio.aws.ssooidc.model
import java.lang.Integer
import zio.aws.ssooidc.model.primitives.{
  TokenType,
  RefreshToken,
  IdToken,
  ExpirationInSeconds,
  AccessToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTokenResponse(
    accessToken: Option[AccessToken] = None,
    tokenType: Option[TokenType] = None,
    expiresIn: Option[ExpirationInSeconds] = None,
    refreshToken: Option[RefreshToken] = None,
    idToken: Option[IdToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse = {
    import CreateTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse
      .builder()
      .optionallyWith(
        accessToken.map(value => AccessToken.unwrap(value): java.lang.String)
      )(_.accessToken)
      .optionallyWith(
        tokenType.map(value => TokenType.unwrap(value): java.lang.String)
      )(_.tokenType)
      .optionallyWith(
        expiresIn.map(value => ExpirationInSeconds.unwrap(value): Integer)
      )(_.expiresIn)
      .optionallyWith(
        refreshToken.map(value => RefreshToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(
        idToken.map(value => IdToken.unwrap(value): java.lang.String)
      )(_.idToken)
      .build()
  }
  def asReadOnly: zio.aws.ssooidc.model.CreateTokenResponse.ReadOnly =
    zio.aws.ssooidc.model.CreateTokenResponse.wrap(buildAwsValue())
}
object CreateTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.CreateTokenResponse =
      zio.aws.ssooidc.model.CreateTokenResponse(
        accessToken.map(value => value),
        tokenType.map(value => value),
        expiresIn.map(value => value),
        refreshToken.map(value => value),
        idToken.map(value => value)
      )
    def accessToken: Option[AccessToken]
    def tokenType: Option[TokenType]
    def expiresIn: Option[ExpirationInSeconds]
    def refreshToken: Option[RefreshToken]
    def idToken: Option[IdToken]
    def getAccessToken: ZIO[Any, AwsError, AccessToken] =
      AwsError.unwrapOptionField("accessToken", accessToken)
    def getTokenType: ZIO[Any, AwsError, TokenType] =
      AwsError.unwrapOptionField("tokenType", tokenType)
    def getExpiresIn: ZIO[Any, AwsError, ExpirationInSeconds] =
      AwsError.unwrapOptionField("expiresIn", expiresIn)
    def getRefreshToken: ZIO[Any, AwsError, RefreshToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getIdToken: ZIO[Any, AwsError, IdToken] =
      AwsError.unwrapOptionField("idToken", idToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse
  ) extends zio.aws.ssooidc.model.CreateTokenResponse.ReadOnly {
    override val accessToken: Option[AccessToken] = scala
      .Option(impl.accessToken())
      .map(value => zio.aws.ssooidc.model.primitives.AccessToken(value))
    override val tokenType: Option[TokenType] = scala
      .Option(impl.tokenType())
      .map(value => zio.aws.ssooidc.model.primitives.TokenType(value))
    override val expiresIn: Option[ExpirationInSeconds] = scala
      .Option(impl.expiresIn())
      .map(value => zio.aws.ssooidc.model.primitives.ExpirationInSeconds(value))
    override val refreshToken: Option[RefreshToken] = scala
      .Option(impl.refreshToken())
      .map(value => zio.aws.ssooidc.model.primitives.RefreshToken(value))
    override val idToken: Option[IdToken] = scala
      .Option(impl.idToken())
      .map(value => zio.aws.ssooidc.model.primitives.IdToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenResponse
  ): zio.aws.ssooidc.model.CreateTokenResponse.ReadOnly = new Wrapper(impl)
}
