package zio.aws.ssooidc.model
import java.lang.Integer
import zio.aws.ssooidc.model.primitives.{
  IntervalInSeconds,
  URI,
  ExpirationInSeconds,
  DeviceCode,
  UserCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartDeviceAuthorizationResponse(
    deviceCode: Option[DeviceCode] = None,
    userCode: Option[UserCode] = None,
    verificationUri: Option[URI] = None,
    verificationUriComplete: Option[URI] = None,
    expiresIn: Option[ExpirationInSeconds] = None,
    interval: Option[IntervalInSeconds] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse = {
    import StartDeviceAuthorizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
      .builder()
      .optionallyWith(
        deviceCode.map(value => DeviceCode.unwrap(value): java.lang.String)
      )(_.deviceCode)
      .optionallyWith(
        userCode.map(value => UserCode.unwrap(value): java.lang.String)
      )(_.userCode)
      .optionallyWith(
        verificationUri.map(value => URI.unwrap(value): java.lang.String)
      )(_.verificationUri)
      .optionallyWith(
        verificationUriComplete.map(value =>
          URI.unwrap(value): java.lang.String
        )
      )(_.verificationUriComplete)
      .optionallyWith(
        expiresIn.map(value => ExpirationInSeconds.unwrap(value): Integer)
      )(_.expiresIn)
      .optionallyWith(
        interval.map(value => IntervalInSeconds.unwrap(value): Integer)
      )(_.interval)
      .build()
  }
  def asReadOnly
      : zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly =
    zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.wrap(buildAwsValue())
}
object StartDeviceAuthorizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.StartDeviceAuthorizationResponse =
      zio.aws.ssooidc.model.StartDeviceAuthorizationResponse(
        deviceCode.map(value => value),
        userCode.map(value => value),
        verificationUri.map(value => value),
        verificationUriComplete.map(value => value),
        expiresIn.map(value => value),
        interval.map(value => value)
      )
    def deviceCode: Option[DeviceCode]
    def userCode: Option[UserCode]
    def verificationUri: Option[URI]
    def verificationUriComplete: Option[URI]
    def expiresIn: Option[ExpirationInSeconds]
    def interval: Option[IntervalInSeconds]
    def getDeviceCode: ZIO[Any, AwsError, DeviceCode] =
      AwsError.unwrapOptionField("deviceCode", deviceCode)
    def getUserCode: ZIO[Any, AwsError, UserCode] =
      AwsError.unwrapOptionField("userCode", userCode)
    def getVerificationUri: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("verificationUri", verificationUri)
    def getVerificationUriComplete: ZIO[Any, AwsError, URI] = AwsError
      .unwrapOptionField("verificationUriComplete", verificationUriComplete)
    def getExpiresIn: ZIO[Any, AwsError, ExpirationInSeconds] =
      AwsError.unwrapOptionField("expiresIn", expiresIn)
    def getInterval: ZIO[Any, AwsError, IntervalInSeconds] =
      AwsError.unwrapOptionField("interval", interval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
  ) extends zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly {
    override val deviceCode: Option[DeviceCode] = scala
      .Option(impl.deviceCode())
      .map(value => zio.aws.ssooidc.model.primitives.DeviceCode(value))
    override val userCode: Option[UserCode] = scala
      .Option(impl.userCode())
      .map(value => zio.aws.ssooidc.model.primitives.UserCode(value))
    override val verificationUri: Option[URI] = scala
      .Option(impl.verificationUri())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val verificationUriComplete: Option[URI] = scala
      .Option(impl.verificationUriComplete())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val expiresIn: Option[ExpirationInSeconds] = scala
      .Option(impl.expiresIn())
      .map(value => zio.aws.ssooidc.model.primitives.ExpirationInSeconds(value))
    override val interval: Option[IntervalInSeconds] = scala
      .Option(impl.interval())
      .map(value => zio.aws.ssooidc.model.primitives.IntervalInSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
  ): zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly =
    new Wrapper(impl)
}
