package zio.aws.ssooidc.model
import zio.aws.ssooidc.model.primitives.{
  GrantType,
  RefreshToken,
  ClientSecret,
  ClientId,
  AuthCode,
  Scope,
  URI,
  DeviceCode
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateTokenRequest(
    clientId: ClientId,
    clientSecret: ClientSecret,
    grantType: GrantType,
    deviceCode: DeviceCode,
    code: Option[AuthCode] = None,
    refreshToken: Option[RefreshToken] = None,
    scope: Option[Iterable[Scope]] = None,
    redirectUri: Option[URI] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest = {
    import CreateTokenRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .clientSecret(ClientSecret.unwrap(clientSecret): java.lang.String)
      .grantType(GrantType.unwrap(grantType): java.lang.String)
      .deviceCode(DeviceCode.unwrap(deviceCode): java.lang.String)
      .optionallyWith(
        code.map(value => AuthCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        refreshToken.map(value => RefreshToken.unwrap(value): java.lang.String)
      )(_.refreshToken)
      .optionallyWith(
        scope.map(value =>
          value.map { item =>
            Scope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scope)
      .optionallyWith(
        redirectUri.map(value => URI.unwrap(value): java.lang.String)
      )(_.redirectUri)
      .build()
  }
  def asReadOnly: zio.aws.ssooidc.model.CreateTokenRequest.ReadOnly =
    zio.aws.ssooidc.model.CreateTokenRequest.wrap(buildAwsValue())
}
object CreateTokenRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.CreateTokenRequest =
      zio.aws.ssooidc.model.CreateTokenRequest(
        clientId,
        clientSecret,
        grantType,
        deviceCode,
        code.map(value => value),
        refreshToken.map(value => value),
        scope.map(value => value),
        redirectUri.map(value => value)
      )
    def clientId: ClientId
    def clientSecret: ClientSecret
    def grantType: GrantType
    def deviceCode: DeviceCode
    def code: Option[AuthCode]
    def refreshToken: Option[RefreshToken]
    def scope: Option[List[Scope]]
    def redirectUri: Option[URI]
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, Nothing, ClientSecret] =
      ZIO.succeed(clientSecret)
    def getGrantType: ZIO[Any, Nothing, GrantType] = ZIO.succeed(grantType)
    def getDeviceCode: ZIO[Any, Nothing, DeviceCode] = ZIO.succeed(deviceCode)
    def getCode: ZIO[Any, AwsError, AuthCode] =
      AwsError.unwrapOptionField("code", code)
    def getRefreshToken: ZIO[Any, AwsError, RefreshToken] =
      AwsError.unwrapOptionField("refreshToken", refreshToken)
    def getScope: ZIO[Any, AwsError, List[Scope]] =
      AwsError.unwrapOptionField("scope", scope)
    def getRedirectUri: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("redirectUri", redirectUri)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
  ) extends zio.aws.ssooidc.model.CreateTokenRequest.ReadOnly {
    override val clientId: ClientId =
      zio.aws.ssooidc.model.primitives.ClientId(impl.clientId())
    override val clientSecret: ClientSecret =
      zio.aws.ssooidc.model.primitives.ClientSecret(impl.clientSecret())
    override val grantType: GrantType =
      zio.aws.ssooidc.model.primitives.GrantType(impl.grantType())
    override val deviceCode: DeviceCode =
      zio.aws.ssooidc.model.primitives.DeviceCode(impl.deviceCode())
    override val code: Option[AuthCode] = scala
      .Option(impl.code())
      .map(value => zio.aws.ssooidc.model.primitives.AuthCode(value))
    override val refreshToken: Option[RefreshToken] = scala
      .Option(impl.refreshToken())
      .map(value => zio.aws.ssooidc.model.primitives.RefreshToken(value))
    override val scope: Option[List[Scope]] = scala
      .Option(impl.scope())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssooidc.model.primitives.Scope(item)
        }.toList
      )
    override val redirectUri: Option[URI] = scala
      .Option(impl.redirectUri())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.CreateTokenRequest
  ): zio.aws.ssooidc.model.CreateTokenRequest.ReadOnly = new Wrapper(impl)
}
