package zio.aws.ssooidc.model
import zio.aws.ssooidc.model.primitives.{URI, ClientSecret, ClientId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartDeviceAuthorizationRequest(
    clientId: ClientId,
    clientSecret: ClientSecret,
    startUrl: URI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest = {
    import StartDeviceAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest
      .builder()
      .clientId(ClientId.unwrap(clientId): java.lang.String)
      .clientSecret(ClientSecret.unwrap(clientSecret): java.lang.String)
      .startUrl(URI.unwrap(startUrl): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssooidc.model.StartDeviceAuthorizationRequest.ReadOnly =
    zio.aws.ssooidc.model.StartDeviceAuthorizationRequest.wrap(buildAwsValue())
}
object StartDeviceAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.StartDeviceAuthorizationRequest =
      zio.aws.ssooidc.model
        .StartDeviceAuthorizationRequest(clientId, clientSecret, startUrl)
    def clientId: ClientId
    def clientSecret: ClientSecret
    def startUrl: URI
    def getClientId: ZIO[Any, Nothing, ClientId] = ZIO.succeed(clientId)
    def getClientSecret: ZIO[Any, Nothing, ClientSecret] =
      ZIO.succeed(clientSecret)
    def getStartUrl: ZIO[Any, Nothing, URI] = ZIO.succeed(startUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest
  ) extends zio.aws.ssooidc.model.StartDeviceAuthorizationRequest.ReadOnly {
    override val clientId: ClientId =
      zio.aws.ssooidc.model.primitives.ClientId(impl.clientId())
    override val clientSecret: ClientSecret =
      zio.aws.ssooidc.model.primitives.ClientSecret(impl.clientSecret())
    override val startUrl: URI =
      zio.aws.ssooidc.model.primitives.URI(impl.startUrl())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationRequest
  ): zio.aws.ssooidc.model.StartDeviceAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
