package zio.aws.ssooidc.model
import zio.aws.ssooidc.model.primitives.{Scope, ClientType, ClientName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterClientRequest(
    clientName: ClientName,
    clientType: ClientType,
    scopes: Option[Iterable[Scope]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest = {
    import RegisterClientRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
      .builder()
      .clientName(ClientName.unwrap(clientName): java.lang.String)
      .clientType(ClientType.unwrap(clientType): java.lang.String)
      .optionallyWith(
        scopes.map(value =>
          value.map { item =>
            Scope.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scopes)
      .build()
  }
  def asReadOnly: zio.aws.ssooidc.model.RegisterClientRequest.ReadOnly =
    zio.aws.ssooidc.model.RegisterClientRequest.wrap(buildAwsValue())
}
object RegisterClientRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.RegisterClientRequest =
      zio.aws.ssooidc.model.RegisterClientRequest(
        clientName,
        clientType,
        scopes.map(value => value)
      )
    def clientName: ClientName
    def clientType: ClientType
    def scopes: Option[List[Scope]]
    def getClientName: ZIO[Any, Nothing, ClientName] = ZIO.succeed(clientName)
    def getClientType: ZIO[Any, Nothing, ClientType] = ZIO.succeed(clientType)
    def getScopes: ZIO[Any, AwsError, List[Scope]] =
      AwsError.unwrapOptionField("scopes", scopes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
  ) extends zio.aws.ssooidc.model.RegisterClientRequest.ReadOnly {
    override val clientName: ClientName =
      zio.aws.ssooidc.model.primitives.ClientName(impl.clientName())
    override val clientType: ClientType =
      zio.aws.ssooidc.model.primitives.ClientType(impl.clientType())
    override val scopes: Option[List[Scope]] = scala
      .Option(impl.scopes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssooidc.model.primitives.Scope(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.RegisterClientRequest
  ): zio.aws.ssooidc.model.RegisterClientRequest.ReadOnly = new Wrapper(impl)
}
