package zio.aws.ssooidc.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssooidc.model.primitives.{
  IntervalInSeconds,
  URI,
  ExpirationInSeconds,
  DeviceCode,
  UserCode
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartDeviceAuthorizationResponse(
    deviceCode: Optional[DeviceCode] = Optional.Absent,
    userCode: Optional[UserCode] = Optional.Absent,
    verificationUri: Optional[URI] = Optional.Absent,
    verificationUriComplete: Optional[URI] = Optional.Absent,
    expiresIn: Optional[ExpirationInSeconds] = Optional.Absent,
    interval: Optional[IntervalInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse = {
    import StartDeviceAuthorizationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
      .builder()
      .optionallyWith(
        deviceCode.map(value => DeviceCode.unwrap(value): java.lang.String)
      )(_.deviceCode)
      .optionallyWith(
        userCode.map(value => UserCode.unwrap(value): java.lang.String)
      )(_.userCode)
      .optionallyWith(
        verificationUri.map(value => URI.unwrap(value): java.lang.String)
      )(_.verificationUri)
      .optionallyWith(
        verificationUriComplete.map(value =>
          URI.unwrap(value): java.lang.String
        )
      )(_.verificationUriComplete)
      .optionallyWith(
        expiresIn.map(value => ExpirationInSeconds.unwrap(value): Integer)
      )(_.expiresIn)
      .optionallyWith(
        interval.map(value => IntervalInSeconds.unwrap(value): Integer)
      )(_.interval)
      .build()
  }
  def asReadOnly
      : zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly =
    zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.wrap(buildAwsValue())
}
object StartDeviceAuthorizationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssooidc.model.StartDeviceAuthorizationResponse =
      zio.aws.ssooidc.model.StartDeviceAuthorizationResponse(
        deviceCode.map(value => value),
        userCode.map(value => value),
        verificationUri.map(value => value),
        verificationUriComplete.map(value => value),
        expiresIn.map(value => value),
        interval.map(value => value)
      )
    def deviceCode: Optional[DeviceCode]
    def userCode: Optional[UserCode]
    def verificationUri: Optional[URI]
    def verificationUriComplete: Optional[URI]
    def expiresIn: Optional[ExpirationInSeconds]
    def interval: Optional[IntervalInSeconds]
    def getDeviceCode: ZIO[Any, AwsError, DeviceCode] =
      AwsError.unwrapOptionField("deviceCode", deviceCode)
    def getUserCode: ZIO[Any, AwsError, UserCode] =
      AwsError.unwrapOptionField("userCode", userCode)
    def getVerificationUri: ZIO[Any, AwsError, URI] =
      AwsError.unwrapOptionField("verificationUri", verificationUri)
    def getVerificationUriComplete: ZIO[Any, AwsError, URI] = AwsError
      .unwrapOptionField("verificationUriComplete", verificationUriComplete)
    def getExpiresIn: ZIO[Any, AwsError, ExpirationInSeconds] =
      AwsError.unwrapOptionField("expiresIn", expiresIn)
    def getInterval: ZIO[Any, AwsError, IntervalInSeconds] =
      AwsError.unwrapOptionField("interval", interval)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
  ) extends zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly {
    override val deviceCode: Optional[DeviceCode] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceCode())
      .map(value => zio.aws.ssooidc.model.primitives.DeviceCode(value))
    override val userCode: Optional[UserCode] = zio.aws.core.internal
      .optionalFromNullable(impl.userCode())
      .map(value => zio.aws.ssooidc.model.primitives.UserCode(value))
    override val verificationUri: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationUri())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val verificationUriComplete: Optional[URI] = zio.aws.core.internal
      .optionalFromNullable(impl.verificationUriComplete())
      .map(value => zio.aws.ssooidc.model.primitives.URI(value))
    override val expiresIn: Optional[ExpirationInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiresIn())
        .map(value =>
          zio.aws.ssooidc.model.primitives.ExpirationInSeconds(value)
        )
    override val interval: Optional[IntervalInSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => zio.aws.ssooidc.model.primitives.IntervalInSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssooidc.model.StartDeviceAuthorizationResponse
  ): zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly =
    new Wrapper(impl)
}
