package zio.aws.ssooidc
import software.amazon.awssdk.services.ssooidc.model.{
  StartDeviceAuthorizationResponse,
  RegisterClientRequest,
  RegisterClientResponse,
  CreateTokenRequest,
  StartDeviceAuthorizationRequest,
  CreateTokenResponse
}
import zio.aws.core.config.AwsConfig
import zio.aws.ssooidc.model.CreateTokenResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.ssooidc.{
  SsoOidcAsyncClientBuilder,
  SsoOidcAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters._
trait SsoOidc extends AspectSupport[SsoOidc] {
  val api: SsoOidcAsyncClient
  def createToken(
      request: zio.aws.ssooidc.model.CreateTokenRequest
  ): IO[AwsError, ReadOnly]
  def registerClient(
      request: zio.aws.ssooidc.model.RegisterClientRequest
  ): IO[AwsError, zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly]
  def startDeviceAuthorization(
      request: zio.aws.ssooidc.model.StartDeviceAuthorizationRequest
  ): IO[
    AwsError,
    zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly
  ]
}
object SsoOidc {
  val live: ZLayer[AwsConfig, java.lang.Throwable, SsoOidc] = customized(
    identity
  )
  def customized(
      customization: SsoOidcAsyncClientBuilder => SsoOidcAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, SsoOidc] = managed(
    customization
  ).toLayer
  def managed(
      customization: SsoOidcAsyncClientBuilder => SsoOidcAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, SsoOidc] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = SsoOidcAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[SsoOidcAsyncClient, SsoOidcAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[SsoOidcAsyncClient, SsoOidcAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new SsoOidcImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class SsoOidcImpl[R](
      override val api: SsoOidcAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends SsoOidc
      with AwsServiceBase[R] {
    override val serviceName: String = "SsoOidc"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): SsoOidcImpl[R1] = new SsoOidcImpl(api, newAspect, r)
    def createToken(
        request: zio.aws.ssooidc.model.CreateTokenRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[CreateTokenRequest, CreateTokenResponse](
        "createToken",
        api.createToken
      )(request.buildAwsValue())
        .map(zio.aws.ssooidc.model.CreateTokenResponse.wrap)
        .provideEnvironment(r)
    def registerClient(
        request: zio.aws.ssooidc.model.RegisterClientRequest
    ): IO[AwsError, zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly] =
      asyncRequestResponse[RegisterClientRequest, RegisterClientResponse](
        "registerClient",
        api.registerClient
      )(request.buildAwsValue())
        .map(zio.aws.ssooidc.model.RegisterClientResponse.wrap)
        .provideEnvironment(r)
    def startDeviceAuthorization(
        request: zio.aws.ssooidc.model.StartDeviceAuthorizationRequest
    ): IO[
      AwsError,
      zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDeviceAuthorizationRequest,
      StartDeviceAuthorizationResponse
    ]("startDeviceAuthorization", api.startDeviceAuthorization)(
      request.buildAwsValue()
    ).map(zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.wrap)
      .provideEnvironment(r)
  }
  def createToken(
      request: zio.aws.ssooidc.model.CreateTokenRequest
  ): ZIO[zio.aws.ssooidc.SsoOidc, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createToken(request))
  def registerClient(request: zio.aws.ssooidc.model.RegisterClientRequest): ZIO[
    zio.aws.ssooidc.SsoOidc,
    AwsError,
    zio.aws.ssooidc.model.RegisterClientResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerClient(request))
  def startDeviceAuthorization(
      request: zio.aws.ssooidc.model.StartDeviceAuthorizationRequest
  ): ZIO[
    zio.aws.ssooidc.SsoOidc,
    AwsError,
    zio.aws.ssooidc.model.StartDeviceAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDeviceAuthorization(request))
}
