package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{
  TargetId,
  PrincipalId,
  PermissionSetArn,
  InstanceArn
}
import scala.jdk.CollectionConverters.*
final case class CreateAccountAssignmentRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    principalId: PrincipalId,
    principalType: zio.aws.ssoadmin.model.PrincipalType,
    targetId: TargetId,
    targetType: zio.aws.ssoadmin.model.TargetType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest = {
    import CreateAccountAssignmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .principalId(PrincipalId.unwrap(principalId): java.lang.String)
      .principalType(principalType.unwrap)
      .targetId(TargetId.unwrap(targetId): java.lang.String)
      .targetType(targetType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.CreateAccountAssignmentRequest.ReadOnly =
    zio.aws.ssoadmin.model.CreateAccountAssignmentRequest.wrap(buildAwsValue())
}
object CreateAccountAssignmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.CreateAccountAssignmentRequest =
      zio.aws.ssoadmin.model.CreateAccountAssignmentRequest(
        instanceArn,
        permissionSetArn,
        principalId,
        principalType,
        targetId,
        targetType
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def principalId: PrincipalId
    def principalType: zio.aws.ssoadmin.model.PrincipalType
    def targetId: TargetId
    def targetType: zio.aws.ssoadmin.model.TargetType
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getPrincipalId: ZIO[Any, Nothing, PrincipalId] =
      ZIO.succeed(principalId)
    def getPrincipalType
        : ZIO[Any, Nothing, zio.aws.ssoadmin.model.PrincipalType] =
      ZIO.succeed(principalType)
    def getTargetId: ZIO[Any, Nothing, TargetId] = ZIO.succeed(targetId)
    def getTargetType: ZIO[Any, Nothing, zio.aws.ssoadmin.model.TargetType] =
      ZIO.succeed(targetType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest
  ) extends zio.aws.ssoadmin.model.CreateAccountAssignmentRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val principalId: PrincipalId =
      zio.aws.ssoadmin.model.primitives.PrincipalId(impl.principalId())
    override val principalType: zio.aws.ssoadmin.model.PrincipalType =
      zio.aws.ssoadmin.model.PrincipalType.wrap(impl.principalType())
    override val targetId: TargetId =
      zio.aws.ssoadmin.model.primitives.TargetId(impl.targetId())
    override val targetType: zio.aws.ssoadmin.model.TargetType =
      zio.aws.ssoadmin.model.TargetType.wrap(impl.targetType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest
  ): zio.aws.ssoadmin.model.CreateAccountAssignmentRequest.ReadOnly =
    new Wrapper(impl)
}
