package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{
  PermissionSetArn,
  InstanceArn,
  PermissionSetPolicyDocument
}
import scala.jdk.CollectionConverters.*
final case class PutInlinePolicyToPermissionSetRequest(
    inlinePolicy: PermissionSetPolicyDocument,
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest = {
    import PutInlinePolicyToPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest
      .builder()
      .inlinePolicy(
        PermissionSetPolicyDocument.unwrap(inlinePolicy): java.lang.String
      )
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetRequest
      .wrap(buildAwsValue())
}
object PutInlinePolicyToPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetRequest =
      zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetRequest(
        inlinePolicy,
        instanceArn,
        permissionSetArn
      )
    def inlinePolicy: PermissionSetPolicyDocument
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def getInlinePolicy: ZIO[Any, Nothing, PermissionSetPolicyDocument] =
      ZIO.succeed(inlinePolicy)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetRequest.ReadOnly {
    override val inlinePolicy: PermissionSetPolicyDocument =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetPolicyDocument(impl.inlinePolicy())
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest
  ): zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
