package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{InstanceArn, UUId}
import scala.jdk.CollectionConverters.*
final case class DescribeAccountAssignmentDeletionStatusRequest(
    accountAssignmentDeletionRequestId: UUId,
    instanceArn: InstanceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest = {
    import DescribeAccountAssignmentDeletionStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
      .builder()
      .accountAssignmentDeletionRequestId(
        UUId.unwrap(accountAssignmentDeletionRequestId): java.lang.String
      )
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest.ReadOnly =
    zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
      .wrap(buildAwsValue())
}
object DescribeAccountAssignmentDeletionStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest =
      zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest(
        accountAssignmentDeletionRequestId,
        instanceArn
      )
    def accountAssignmentDeletionRequestId: UUId
    def instanceArn: InstanceArn
    def getAccountAssignmentDeletionRequestId: ZIO[Any, Nothing, UUId] =
      ZIO.succeed(accountAssignmentDeletionRequestId)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
  ) extends zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest.ReadOnly {
    override val accountAssignmentDeletionRequestId: UUId =
      zio.aws.ssoadmin.model.primitives
        .UUId(impl.accountAssignmentDeletionRequestId())
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
  ): zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest.ReadOnly =
    new Wrapper(impl)
}
