package zio.aws.ssoadmin.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{UUId, Date}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AccountAssignmentOperationStatusMetadata(
    createdDate: Optional[Date] = Optional.Absent,
    requestId: Optional[UUId] = Optional.Absent,
    status: Optional[zio.aws.ssoadmin.model.StatusValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata = {
    import AccountAssignmentOperationStatusMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata
      .builder()
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(
        requestId.map(value => UUId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly =
    zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata
      .wrap(buildAwsValue())
}
object AccountAssignmentOperationStatusMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata =
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata(
        createdDate.map(value => value),
        requestId.map(value => value),
        status.map(value => value)
      )
    def createdDate: Optional[Date]
    def requestId: Optional[UUId]
    def status: Optional[zio.aws.ssoadmin.model.StatusValues]
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getRequestId: ZIO[Any, AwsError, UUId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata
  ) extends zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly {
    override val createdDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
    override val requestId: Optional[UUId] = zio.aws.core.internal
      .optionalFromNullable(impl.requestId())
      .map(value => zio.aws.ssoadmin.model.primitives.UUId(value))
    override val status: Optional[zio.aws.ssoadmin.model.StatusValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata
  ): zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly =
    new Wrapper(impl)
}
