package zio.aws.ssoadmin.model
import scala.jdk.CollectionConverters.*
sealed trait StatusValues {
  def unwrap: software.amazon.awssdk.services.ssoadmin.model.StatusValues
}
object StatusValues {
  def wrap(
      value: software.amazon.awssdk.services.ssoadmin.model.StatusValues
  ): zio.aws.ssoadmin.model.StatusValues = value match {
    case software.amazon.awssdk.services.ssoadmin.model.StatusValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssoadmin.model.StatusValues.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.ssoadmin.model.StatusValues.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.ssoadmin.model.StatusValues.SUCCEEDED =>
      val r = SUCCEEDED
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssoadmin.model.StatusValues {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.StatusValues =
      software.amazon.awssdk.services.ssoadmin.model.StatusValues.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.ssoadmin.model.StatusValues {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.StatusValues =
      software.amazon.awssdk.services.ssoadmin.model.StatusValues.IN_PROGRESS
  }
  case object FAILED extends zio.aws.ssoadmin.model.StatusValues {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.StatusValues =
      software.amazon.awssdk.services.ssoadmin.model.StatusValues.FAILED
  }
  case object SUCCEEDED extends zio.aws.ssoadmin.model.StatusValues {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.StatusValues =
      software.amazon.awssdk.services.ssoadmin.model.StatusValues.SUCCEEDED
  }
}
