package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(
    customerManagedPolicyReference: zio.aws.ssoadmin.model.CustomerManagedPolicyReference,
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest = {
    import DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
      .builder()
      .customerManagedPolicyReference(
        customerManagedPolicyReference.buildAwsValue()
      )
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
      .wrap(buildAwsValue())
}
object DetachCustomerManagedPolicyReferenceFromPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest =
      zio.aws.ssoadmin.model
        .DetachCustomerManagedPolicyReferenceFromPermissionSetRequest(
          customerManagedPolicyReference.asEditable,
          instanceArn,
          permissionSetArn
        )
    def customerManagedPolicyReference
        : zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def getCustomerManagedPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    ] = ZIO.succeed(customerManagedPolicyReference)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.ReadOnly {
    override val customerManagedPolicyReference
        : zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly =
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference
        .wrap(impl.customerManagedPolicyReference())
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
  ): zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
