package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.InstanceAccessControlAttributeConfigurationStatusReason
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeInstanceAccessControlAttributeConfigurationResponse(
    instanceAccessControlAttributeConfiguration: Optional[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
    ] = Optional.Absent,
    status: Optional[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ] = Optional.Absent,
    statusReason: Optional[
      InstanceAccessControlAttributeConfigurationStatusReason
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse = {
    import DescribeInstanceAccessControlAttributeConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
      .builder()
      .optionallyWith(
        instanceAccessControlAttributeConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.instanceAccessControlAttributeConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusReason.map(value =>
          InstanceAccessControlAttributeConfigurationStatusReason.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusReason)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly =
    zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeInstanceAccessControlAttributeConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse =
      zio.aws.ssoadmin.model
        .DescribeInstanceAccessControlAttributeConfigurationResponse(
          instanceAccessControlAttributeConfiguration.map(value =>
            value.asEditable
          ),
          status.map(value => value),
          statusReason.map(value => value)
        )
    def instanceAccessControlAttributeConfiguration: Optional[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ]
    def status: Optional[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ]
    def statusReason
        : Optional[InstanceAccessControlAttributeConfigurationStatusReason]
    def getInstanceAccessControlAttributeConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceAccessControlAttributeConfiguration",
      instanceAccessControlAttributeConfiguration
    )
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[
      Any,
      AwsError,
      InstanceAccessControlAttributeConfigurationStatusReason
    ] = AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
  ) extends zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly {
    override val instanceAccessControlAttributeConfiguration: Optional[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceAccessControlAttributeConfiguration())
      .map(value =>
        zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
          .wrap(value)
      )
    override val status: Optional[
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value =>
        zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfigurationStatus
          .wrap(value)
      )
    override val statusReason
        : Optional[InstanceAccessControlAttributeConfigurationStatusReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusReason())
        .map(value =>
          zio.aws.ssoadmin.model.primitives
            .InstanceAccessControlAttributeConfigurationStatusReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
  ): zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
