package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  TaggableResourceArn,
  Token,
  InstanceArn
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(
    instanceArn: InstanceArn,
    nextToken: Optional[Token] = Optional.Absent,
    resourceArn: TaggableResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .resourceArn(TaggableResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListTagsForResourceRequest =
      zio.aws.ssoadmin.model.ListTagsForResourceRequest(
        instanceArn,
        nextToken.map(value => value),
        resourceArn
      )
    def instanceArn: InstanceArn
    def nextToken: Optional[Token]
    def resourceArn: TaggableResourceArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getResourceArn: ZIO[Any, Nothing, TaggableResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
  ) extends zio.aws.ssoadmin.model.ListTagsForResourceRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val resourceArn: TaggableResourceArn =
      zio.aws.ssoadmin.model.primitives.TaggableResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest
  ): zio.aws.ssoadmin.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
