package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPermissionSetProvisioningStatusResponse(
    nextToken: Optional[Token] = Optional.Absent,
    permissionSetsProvisioningStatus: Optional[
      Iterable[zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse = {
    import ListPermissionSetProvisioningStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        permissionSetsProvisioningStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.permissionSetsProvisioningStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
      .wrap(buildAwsValue())
}
object ListPermissionSetProvisioningStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse =
      zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse(
        nextToken.map(value => value),
        permissionSetsProvisioningStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[Token]
    def permissionSetsProvisioningStatus: Optional[List[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
    ]]
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPermissionSetsProvisioningStatus: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "permissionSetsProvisioningStatus",
      permissionSetsProvisioningStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
  ) extends zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly {
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val permissionSetsProvisioningStatus: Optional[List[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionSetsProvisioningStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
  ): zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly =
    new Wrapper(impl)
}
