package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.InstanceArn
import scala.jdk.CollectionConverters.*
final case class CreateInstanceAccessControlAttributeConfigurationRequest(
    instanceAccessControlAttributeConfiguration: zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration,
    instanceArn: InstanceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest = {
    import CreateInstanceAccessControlAttributeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
      .builder()
      .instanceAccessControlAttributeConfiguration(
        instanceAccessControlAttributeConfiguration.buildAwsValue()
      )
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateInstanceAccessControlAttributeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest =
      zio.aws.ssoadmin.model
        .CreateInstanceAccessControlAttributeConfigurationRequest(
          instanceAccessControlAttributeConfiguration.asEditable,
          instanceArn
        )
    def instanceAccessControlAttributeConfiguration
        : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    def instanceArn: InstanceArn
    def getInstanceAccessControlAttributeConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ] = ZIO.succeed(instanceAccessControlAttributeConfiguration)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
  ) extends zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest.ReadOnly {
    override val instanceAccessControlAttributeConfiguration
        : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly =
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
        .wrap(impl.instanceAccessControlAttributeConfiguration())
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
  ): zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
