package zio.aws.ssoadmin.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  Date,
  PermissionSetName,
  RelayState,
  PermissionSetArn,
  Duration,
  PermissionSetDescription
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PermissionSet(
    name: Optional[PermissionSetName] = Optional.Absent,
    permissionSetArn: Optional[PermissionSetArn] = Optional.Absent,
    description: Optional[PermissionSetDescription] = Optional.Absent,
    createdDate: Optional[Date] = Optional.Absent,
    sessionDuration: Optional[Duration] = Optional.Absent,
    relayState: Optional[RelayState] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PermissionSet = {
    import PermissionSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PermissionSet
      .builder()
      .optionallyWith(
        name.map(value => PermissionSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        permissionSetArn.map(value =>
          PermissionSetArn.unwrap(value): java.lang.String
        )
      )(_.permissionSetArn)
      .optionallyWith(
        description.map(value =>
          PermissionSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(
        sessionDuration.map(value => Duration.unwrap(value): java.lang.String)
      )(_.sessionDuration)
      .optionallyWith(
        relayState.map(value => RelayState.unwrap(value): java.lang.String)
      )(_.relayState)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.PermissionSet.ReadOnly =
    zio.aws.ssoadmin.model.PermissionSet.wrap(buildAwsValue())
}
object PermissionSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PermissionSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.PermissionSet =
      zio.aws.ssoadmin.model.PermissionSet(
        name.map(value => value),
        permissionSetArn.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        sessionDuration.map(value => value),
        relayState.map(value => value)
      )
    def name: Optional[PermissionSetName]
    def permissionSetArn: Optional[PermissionSetArn]
    def description: Optional[PermissionSetDescription]
    def createdDate: Optional[Date]
    def sessionDuration: Optional[Duration]
    def relayState: Optional[RelayState]
    def getName: ZIO[Any, AwsError, PermissionSetName] =
      AwsError.unwrapOptionField("name", name)
    def getPermissionSetArn: ZIO[Any, AwsError, PermissionSetArn] =
      AwsError.unwrapOptionField("permissionSetArn", permissionSetArn)
    def getDescription: ZIO[Any, AwsError, PermissionSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getSessionDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("sessionDuration", sessionDuration)
    def getRelayState: ZIO[Any, AwsError, RelayState] =
      AwsError.unwrapOptionField("relayState", relayState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSet
  ) extends zio.aws.ssoadmin.model.PermissionSet.ReadOnly {
    override val name: Optional[PermissionSetName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetName(value))
    override val permissionSetArn: Optional[PermissionSetArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionSetArn())
        .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetArn(value))
    override val description: Optional[PermissionSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssoadmin.model.primitives.PermissionSetDescription(value)
        )
    override val createdDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
    override val sessionDuration: Optional[Duration] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionDuration())
      .map(value => zio.aws.ssoadmin.model.primitives.Duration(value))
    override val relayState: Optional[RelayState] = zio.aws.core.internal
      .optionalFromNullable(impl.relayState())
      .map(value => zio.aws.ssoadmin.model.primitives.RelayState(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSet
  ): zio.aws.ssoadmin.model.PermissionSet.ReadOnly = new Wrapper(impl)
}
