package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePermissionSetResponse(
    permissionSet: Optional[zio.aws.ssoadmin.model.PermissionSet] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse = {
    import DescribePermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
      .builder()
      .optionallyWith(permissionSet.map(value => value.buildAwsValue()))(
        _.permissionSet
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.DescribePermissionSetResponse.wrap(buildAwsValue())
}
object DescribePermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.DescribePermissionSetResponse =
      zio.aws.ssoadmin.model.DescribePermissionSetResponse(
        permissionSet.map(value => value.asEditable)
      )
    def permissionSet: Optional[zio.aws.ssoadmin.model.PermissionSet.ReadOnly]
    def getPermissionSet
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.PermissionSet.ReadOnly] =
      AwsError.unwrapOptionField("permissionSet", permissionSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
  ) extends zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly {
    override val permissionSet
        : Optional[zio.aws.ssoadmin.model.PermissionSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.permissionSet())
        .map(value => zio.aws.ssoadmin.model.PermissionSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse
  ): zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
