package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ProvisionPermissionSetResponse(
    permissionSetProvisioningStatus: Optional[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse = {
    import ProvisionPermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse
      .builder()
      .optionallyWith(
        permissionSetProvisioningStatus.map(value => value.buildAwsValue())
      )(_.permissionSetProvisioningStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ProvisionPermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.ProvisionPermissionSetResponse.wrap(buildAwsValue())
}
object ProvisionPermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ProvisionPermissionSetResponse =
      zio.aws.ssoadmin.model.ProvisionPermissionSetResponse(
        permissionSetProvisioningStatus.map(value => value.asEditable)
      )
    def permissionSetProvisioningStatus: Optional[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly
    ]
    def getPermissionSetProvisioningStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "permissionSetProvisioningStatus",
      permissionSetProvisioningStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse
  ) extends zio.aws.ssoadmin.model.ProvisionPermissionSetResponse.ReadOnly {
    override val permissionSetProvisioningStatus: Optional[
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.permissionSetProvisioningStatus())
      .map(value =>
        zio.aws.ssoadmin.model.PermissionSetProvisioningStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse
  ): zio.aws.ssoadmin.model.ProvisionPermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
