package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class GetPermissionsBoundaryForPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest = {
    import GetPermissionsBoundaryForPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest
      .wrap(buildAwsValue())
}
object GetPermissionsBoundaryForPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest =
      zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest(
        instanceArn,
        permissionSetArn
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest
  ): zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
