package zio.aws.ssoadmin.model
import zio.prelude.data.Optional
import zio.aws.ssoadmin.model.primitives.{
  InstanceArn,
  Token,
  MaxResults,
  PermissionSetArn,
  TargetId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListAccountAssignmentsRequest(
    instanceArn: InstanceArn,
    accountId: TargetId,
    permissionSetArn: PermissionSetArn,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest = {
    import ListAccountAssignmentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .accountId(TargetId.unwrap(accountId): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountAssignmentsRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountAssignmentsRequest.wrap(buildAwsValue())
}
object ListAccountAssignmentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListAccountAssignmentsRequest =
      zio.aws.ssoadmin.model.ListAccountAssignmentsRequest(
        instanceArn,
        accountId,
        permissionSetArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceArn: InstanceArn
    def accountId: TargetId
    def permissionSetArn: PermissionSetArn
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[Token]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getAccountId: ZIO[Any, Nothing, TargetId] = ZIO.succeed(accountId)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest
  ) extends zio.aws.ssoadmin.model.ListAccountAssignmentsRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val accountId: TargetId =
      zio.aws.ssoadmin.model.primitives.TargetId(impl.accountId())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest
  ): zio.aws.ssoadmin.model.ListAccountAssignmentsRequest.ReadOnly =
    new Wrapper(impl)
}
