package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAccountAssignmentCreationStatusResponse(
    accountAssignmentsCreationStatus: Optional[
      Iterable[zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse = {
    import ListAccountAssignmentCreationStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse
      .builder()
      .optionallyWith(
        accountAssignmentsCreationStatus.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountAssignmentsCreationStatus)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse
      .wrap(buildAwsValue())
}
object ListAccountAssignmentCreationStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse =
      zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse(
        accountAssignmentsCreationStatus.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def accountAssignmentsCreationStatus: Optional[List[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ]]
    def nextToken: Optional[Token]
    def getAccountAssignmentsCreationStatus: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountAssignmentsCreationStatus",
      accountAssignmentsCreationStatus
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse
  ) extends zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly {
    override val accountAssignmentsCreationStatus: Optional[List[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.accountAssignmentsCreationStatus())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse
  ): zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly =
    new Wrapper(impl)
}
