package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.AccessControlAttributeValueSource
import scala.jdk.CollectionConverters.*
final case class AccessControlAttributeValue(
    source: Iterable[AccessControlAttributeValueSource]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AccessControlAttributeValue = {
    import AccessControlAttributeValue.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AccessControlAttributeValue
      .builder()
      .source(source.map { item =>
        AccessControlAttributeValueSource.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.AccessControlAttributeValue.ReadOnly =
    zio.aws.ssoadmin.model.AccessControlAttributeValue.wrap(buildAwsValue())
}
object AccessControlAttributeValue {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AccessControlAttributeValue
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.AccessControlAttributeValue =
      zio.aws.ssoadmin.model.AccessControlAttributeValue(source)
    def source: List[AccessControlAttributeValueSource]
    def getSource: ZIO[Any, Nothing, List[AccessControlAttributeValueSource]] =
      ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccessControlAttributeValue
  ) extends zio.aws.ssoadmin.model.AccessControlAttributeValue.ReadOnly {
    override val source: List[AccessControlAttributeValueSource] = impl
      .source()
      .asScala
      .map { item =>
        zio.aws.ssoadmin.model.primitives
          .AccessControlAttributeValueSource(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccessControlAttributeValue
  ): zio.aws.ssoadmin.model.AccessControlAttributeValue.ReadOnly = new Wrapper(
    impl
  )
}
