package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{PermissionSetArn, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class AttachCustomerManagedPolicyReferenceToPermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    customerManagedPolicyReference: zio.aws.ssoadmin.model.CustomerManagedPolicyReference
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest = {
    import AttachCustomerManagedPolicyReferenceToPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .customerManagedPolicyReference(
        customerManagedPolicyReference.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest
      .wrap(buildAwsValue())
}
object AttachCustomerManagedPolicyReferenceToPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest =
      zio.aws.ssoadmin.model
        .AttachCustomerManagedPolicyReferenceToPermissionSetRequest(
          instanceArn,
          permissionSetArn,
          customerManagedPolicyReference.asEditable
        )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def customerManagedPolicyReference
        : zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getCustomerManagedPolicyReference: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    ] = ZIO.succeed(customerManagedPolicyReference)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val customerManagedPolicyReference
        : zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly =
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference
        .wrap(impl.customerManagedPolicyReference())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest
  ): zio.aws.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
