package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.AccessControlAttributeKey
import scala.jdk.CollectionConverters.*
final case class AccessControlAttribute(
    key: AccessControlAttributeKey,
    value: zio.aws.ssoadmin.model.AccessControlAttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute = {
    import AccessControlAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute
      .builder()
      .key(AccessControlAttributeKey.unwrap(key): java.lang.String)
      .value(value.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.AccessControlAttribute.ReadOnly =
    zio.aws.ssoadmin.model.AccessControlAttribute.wrap(buildAwsValue())
}
object AccessControlAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.AccessControlAttribute =
      zio.aws.ssoadmin.model.AccessControlAttribute(key, value.asEditable)
    def key: AccessControlAttributeKey
    def value: zio.aws.ssoadmin.model.AccessControlAttributeValue.ReadOnly
    def getKey: ZIO[Any, Nothing, AccessControlAttributeKey] = ZIO.succeed(key)
    def getValue: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.AccessControlAttributeValue.ReadOnly
    ] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute
  ) extends zio.aws.ssoadmin.model.AccessControlAttribute.ReadOnly {
    override val key: AccessControlAttributeKey =
      zio.aws.ssoadmin.model.primitives.AccessControlAttributeKey(impl.key())
    override val value
        : zio.aws.ssoadmin.model.AccessControlAttributeValue.ReadOnly =
      zio.aws.ssoadmin.model.AccessControlAttributeValue.wrap(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccessControlAttribute
  ): zio.aws.ssoadmin.model.AccessControlAttribute.ReadOnly = new Wrapper(impl)
}
