package zio.aws.ssoadmin
import zio.aws.ssoadmin.model.ProvisionPermissionSetResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.ssoadmin.model.primitives.{AccountId, PermissionSetArn}
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ssoadmin.model.{
  ListPermissionSetsRequest,
  CreateAccountAssignmentRequest,
  DeleteInlinePolicyFromPermissionSetRequest,
  DeletePermissionsBoundaryFromPermissionSetRequest,
  PutPermissionsBoundaryToPermissionSetRequest,
  CreateInstanceAccessControlAttributeConfigurationRequest,
  ListPermissionSetsProvisionedToAccountRequest,
  ListInstancesRequest,
  DetachCustomerManagedPolicyReferenceFromPermissionSetRequest,
  AttachManagedPolicyToPermissionSetRequest,
  ListTagsForResourceRequest,
  DetachManagedPolicyFromPermissionSetRequest,
  ListAccountAssignmentsRequest,
  AttachCustomerManagedPolicyReferenceToPermissionSetRequest,
  DescribeInstanceAccessControlAttributeConfigurationRequest,
  DescribeAccountAssignmentDeletionStatusRequest,
  DeleteInstanceAccessControlAttributeConfigurationRequest,
  DescribePermissionSetRequest,
  GetInlinePolicyForPermissionSetRequest,
  ProvisionPermissionSetRequest,
  ListManagedPoliciesInPermissionSetRequest,
  UpdateInstanceAccessControlAttributeConfigurationRequest,
  CreatePermissionSetRequest,
  UntagResourceRequest,
  DeletePermissionSetRequest,
  ListPermissionSetProvisioningStatusRequest,
  DescribePermissionSetProvisioningStatusRequest,
  ListCustomerManagedPolicyReferencesInPermissionSetRequest,
  PutInlinePolicyToPermissionSetRequest,
  DeleteAccountAssignmentRequest,
  DescribeAccountAssignmentCreationStatusRequest,
  ListAccountAssignmentDeletionStatusRequest,
  UpdatePermissionSetRequest,
  ListAccountsForProvisionedPermissionSetRequest,
  GetPermissionsBoundaryForPermissionSetRequest,
  TagResourceRequest,
  ListAccountAssignmentCreationStatusRequest
}
import zio.stream.ZStream
object SsoAdminMock extends Mock[SsoAdmin] {
  object AttachCustomerManagedPolicyReferenceToPermissionSet
      extends Effect[
        AttachCustomerManagedPolicyReferenceToPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetResponse.ReadOnly
      ]
  object DescribePermissionSetProvisioningStatus
      extends Effect[
        DescribePermissionSetProvisioningStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse.ReadOnly
      ]
  object ListPermissionSets
      extends Stream[ListPermissionSetsRequest, AwsError, PermissionSetArn]
  object ListPermissionSetsPaginated
      extends Effect[
        ListPermissionSetsRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly
      ]
  object ListAccountAssignmentDeletionStatus
      extends Stream[
        ListAccountAssignmentDeletionStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
      ]
  object ListAccountAssignmentDeletionStatusPaginated
      extends Effect[
        ListAccountAssignmentDeletionStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly
      ]
  object DetachManagedPolicyFromPermissionSet
      extends Effect[
        DetachManagedPolicyFromPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse.ReadOnly
      ]
  object DescribePermissionSet
      extends Effect[
        DescribePermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly
      ]
  object DescribeInstanceAccessControlAttributeConfiguration
      extends Effect[
        DescribeInstanceAccessControlAttributeConfigurationRequest,
        AwsError,
        zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly
      ]
  object ListManagedPoliciesInPermissionSet
      extends Stream[
        ListManagedPoliciesInPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly
      ]
  object ListManagedPoliciesInPermissionSetPaginated
      extends Effect[
        ListManagedPoliciesInPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly
      ]
  object CreatePermissionSet
      extends Effect[
        CreatePermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly
      ]
  object CreateAccountAssignment
      extends Effect[
        CreateAccountAssignmentRequest,
        AwsError,
        zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly
      ]
  object ListInstances
      extends Stream[
        ListInstancesRequest,
        AwsError,
        zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly
      ]
  object ListInstancesPaginated
      extends Effect[
        ListInstancesRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly
      ]
  object ListAccountAssignmentCreationStatus
      extends Stream[
        ListAccountAssignmentCreationStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
      ]
  object ListAccountAssignmentCreationStatusPaginated
      extends Effect[
        ListAccountAssignmentCreationStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly
      ]
  object DetachCustomerManagedPolicyReferenceFromPermissionSet
      extends Effect[
        DetachCustomerManagedPolicyReferenceFromPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetResponse.ReadOnly
      ]
  object GetPermissionsBoundaryForPermissionSet
      extends Effect[
        GetPermissionsBoundaryForPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse.ReadOnly
      ]
  object UpdatePermissionSet
      extends Effect[
        UpdatePermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.UpdatePermissionSetResponse.ReadOnly
      ]
  object DeleteInlinePolicyFromPermissionSet
      extends Effect[
        DeleteInlinePolicyFromPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse.ReadOnly
      ]
  object GetInlinePolicyForPermissionSet
      extends Effect[
        GetInlinePolicyForPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly
      ]
  object AttachManagedPolicyToPermissionSet
      extends Effect[
        AttachManagedPolicyToPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse.ReadOnly
      ]
  object DescribeAccountAssignmentDeletionStatus
      extends Effect[
        DescribeAccountAssignmentDeletionStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ssoadmin.model.UntagResourceResponse.ReadOnly
      ]
  object PutPermissionsBoundaryToPermissionSet
      extends Effect[
        PutPermissionsBoundaryToPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetResponse.ReadOnly
      ]
  object DeleteInstanceAccessControlAttributeConfiguration
      extends Effect[
        DeleteInstanceAccessControlAttributeConfigurationRequest,
        AwsError,
        zio.aws.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse.ReadOnly
      ]
  object DeletePermissionSet
      extends Effect[
        DeletePermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.DeletePermissionSetResponse.ReadOnly
      ]
  object DescribeAccountAssignmentCreationStatus
      extends Effect[
        DescribeAccountAssignmentCreationStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly
      ]
  object ListPermissionSetProvisioningStatus
      extends Stream[
        ListPermissionSetProvisioningStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
      ]
  object ListPermissionSetProvisioningStatusPaginated
      extends Effect[
        ListPermissionSetProvisioningStatusRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ssoadmin.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ssoadmin.model.TagResourceResponse.ReadOnly
      ]
  object DeletePermissionsBoundaryFromPermissionSet
      extends Effect[
        DeletePermissionsBoundaryFromPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetResponse.ReadOnly
      ]
  object ProvisionPermissionSet
      extends Effect[ProvisionPermissionSetRequest, AwsError, ReadOnly]
  object ListAccountsForProvisionedPermissionSet
      extends Stream[
        ListAccountsForProvisionedPermissionSetRequest,
        AwsError,
        AccountId
      ]
  object ListAccountsForProvisionedPermissionSetPaginated
      extends Effect[
        ListAccountsForProvisionedPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly
      ]
  object CreateInstanceAccessControlAttributeConfiguration
      extends Effect[
        CreateInstanceAccessControlAttributeConfigurationRequest,
        AwsError,
        zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
      ]
  object ListPermissionSetsProvisionedToAccount
      extends Stream[
        ListPermissionSetsProvisionedToAccountRequest,
        AwsError,
        PermissionSetArn
      ]
  object ListPermissionSetsProvisionedToAccountPaginated
      extends Effect[
        ListPermissionSetsProvisionedToAccountRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly
      ]
  object PutInlinePolicyToPermissionSet
      extends Effect[
        PutInlinePolicyToPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetResponse.ReadOnly
      ]
  object ListCustomerManagedPolicyReferencesInPermissionSet
      extends Stream[
        ListCustomerManagedPolicyReferencesInPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
      ]
  object ListCustomerManagedPolicyReferencesInPermissionSetPaginated
      extends Effect[
        ListCustomerManagedPolicyReferencesInPermissionSetRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse.ReadOnly
      ]
  object ListAccountAssignments
      extends Stream[
        ListAccountAssignmentsRequest,
        AwsError,
        zio.aws.ssoadmin.model.AccountAssignment.ReadOnly
      ]
  object ListAccountAssignmentsPaginated
      extends Effect[
        ListAccountAssignmentsRequest,
        AwsError,
        zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly
      ]
  object DeleteAccountAssignment
      extends Effect[
        DeleteAccountAssignmentRequest,
        AwsError,
        zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly
      ]
  object UpdateInstanceAccessControlAttributeConfiguration
      extends Effect[
        UpdateInstanceAccessControlAttributeConfigurationRequest,
        AwsError,
        zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, SsoAdmin] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, SsoAdmin] { rts =>
        zio.ZIO.succeed {
          new SsoAdmin {
            val api: SsoAdminAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): SsoAdmin = this
            def attachCustomerManagedPolicyReferenceToPermissionSet(
                request: AttachCustomerManagedPolicyReferenceToPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetResponse.ReadOnly
            ] = proxy(
              AttachCustomerManagedPolicyReferenceToPermissionSet,
              request
            )
            def describePermissionSetProvisioningStatus(
                request: DescribePermissionSetProvisioningStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse.ReadOnly
            ] = proxy(DescribePermissionSetProvisioningStatus, request)
            def listPermissionSets(
                request: ListPermissionSetsRequest
            ): ZStream[Any, AwsError, PermissionSetArn] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListPermissionSets, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listPermissionSetsPaginated(
                request: ListPermissionSetsRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListPermissionSetsResponse.ReadOnly
            ] = proxy(ListPermissionSetsPaginated, request)
            def listAccountAssignmentDeletionStatus(
                request: ListAccountAssignmentDeletionStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccountAssignmentDeletionStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccountAssignmentDeletionStatusPaginated(
                request: ListAccountAssignmentDeletionStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse.ReadOnly
            ] = proxy(ListAccountAssignmentDeletionStatusPaginated, request)
            def detachManagedPolicyFromPermissionSet(
                request: DetachManagedPolicyFromPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse.ReadOnly
            ] = proxy(DetachManagedPolicyFromPermissionSet, request)
            def describePermissionSet(
                request: DescribePermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DescribePermissionSetResponse.ReadOnly
            ] = proxy(DescribePermissionSet, request)
            def describeInstanceAccessControlAttributeConfiguration(
                request: DescribeInstanceAccessControlAttributeConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse.ReadOnly
            ] = proxy(
              DescribeInstanceAccessControlAttributeConfiguration,
              request
            )
            def listManagedPoliciesInPermissionSet(
                request: ListManagedPoliciesInPermissionSetRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListManagedPoliciesInPermissionSet, request)
                }
                .getOrThrowFiberFailure()
            }
            def listManagedPoliciesInPermissionSetPaginated(
                request: ListManagedPoliciesInPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly
            ] = proxy(ListManagedPoliciesInPermissionSetPaginated, request)
            def createPermissionSet(request: CreatePermissionSetRequest): IO[
              AwsError,
              zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly
            ] = proxy(CreatePermissionSet, request)
            def createAccountAssignment(
                request: CreateAccountAssignmentRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.CreateAccountAssignmentResponse.ReadOnly
            ] = proxy(CreateAccountAssignment, request)
            def listInstances(request: ListInstancesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.ssoadmin.model.InstanceMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListInstances, request)
                }
                .getOrThrowFiberFailure()
            }
            def listInstancesPaginated(request: ListInstancesRequest): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListInstancesResponse.ReadOnly
            ] = proxy(ListInstancesPaginated, request)
            def listAccountAssignmentCreationStatus(
                request: ListAccountAssignmentCreationStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccountAssignmentCreationStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccountAssignmentCreationStatusPaginated(
                request: ListAccountAssignmentCreationStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListAccountAssignmentCreationStatusResponse.ReadOnly
            ] = proxy(ListAccountAssignmentCreationStatusPaginated, request)
            def detachCustomerManagedPolicyReferenceFromPermissionSet(
                request: DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetResponse.ReadOnly
            ] = proxy(
              DetachCustomerManagedPolicyReferenceFromPermissionSet,
              request
            )
            def getPermissionsBoundaryForPermissionSet(
                request: GetPermissionsBoundaryForPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse.ReadOnly
            ] = proxy(GetPermissionsBoundaryForPermissionSet, request)
            def updatePermissionSet(request: UpdatePermissionSetRequest): IO[
              AwsError,
              zio.aws.ssoadmin.model.UpdatePermissionSetResponse.ReadOnly
            ] = proxy(UpdatePermissionSet, request)
            def deleteInlinePolicyFromPermissionSet(
                request: DeleteInlinePolicyFromPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse.ReadOnly
            ] = proxy(DeleteInlinePolicyFromPermissionSet, request)
            def getInlinePolicyForPermissionSet(
                request: GetInlinePolicyForPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.GetInlinePolicyForPermissionSetResponse.ReadOnly
            ] = proxy(GetInlinePolicyForPermissionSet, request)
            def attachManagedPolicyToPermissionSet(
                request: AttachManagedPolicyToPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse.ReadOnly
            ] = proxy(AttachManagedPolicyToPermissionSet, request)
            def describeAccountAssignmentDeletionStatus(
                request: DescribeAccountAssignmentDeletionStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse.ReadOnly
            ] = proxy(DescribeAccountAssignmentDeletionStatus, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.ssoadmin.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def putPermissionsBoundaryToPermissionSet(
                request: PutPermissionsBoundaryToPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.PutPermissionsBoundaryToPermissionSetResponse.ReadOnly
            ] = proxy(PutPermissionsBoundaryToPermissionSet, request)
            def deleteInstanceAccessControlAttributeConfiguration(
                request: DeleteInstanceAccessControlAttributeConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse.ReadOnly
            ] =
              proxy(DeleteInstanceAccessControlAttributeConfiguration, request)
            def deletePermissionSet(request: DeletePermissionSetRequest): IO[
              AwsError,
              zio.aws.ssoadmin.model.DeletePermissionSetResponse.ReadOnly
            ] = proxy(DeletePermissionSet, request)
            def describeAccountAssignmentCreationStatus(
                request: DescribeAccountAssignmentCreationStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse.ReadOnly
            ] = proxy(DescribeAccountAssignmentCreationStatus, request)
            def listPermissionSetProvisioningStatus(
                request: ListPermissionSetProvisioningStatusRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListPermissionSetProvisioningStatus, request)
                }
                .getOrThrowFiberFailure()
            }
            def listPermissionSetProvisioningStatusPaginated(
                request: ListPermissionSetProvisioningStatusRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListPermissionSetProvisioningStatusResponse.ReadOnly
            ] = proxy(ListPermissionSetProvisioningStatusPaginated, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.ssoadmin.model.Tag.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTagsForResource, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.ssoadmin.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def deletePermissionsBoundaryFromPermissionSet(
                request: DeletePermissionsBoundaryFromPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetResponse.ReadOnly
            ] = proxy(DeletePermissionsBoundaryFromPermissionSet, request)
            def provisionPermissionSet(
                request: ProvisionPermissionSetRequest
            ): IO[AwsError, ReadOnly] = proxy(ProvisionPermissionSet, request)
            def listAccountsForProvisionedPermissionSet(
                request: ListAccountsForProvisionedPermissionSetRequest
            ): ZStream[Any, AwsError, AccountId] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListAccountsForProvisionedPermissionSet, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listAccountsForProvisionedPermissionSetPaginated(
                request: ListAccountsForProvisionedPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse.ReadOnly
            ] = proxy(ListAccountsForProvisionedPermissionSetPaginated, request)
            def createInstanceAccessControlAttributeConfiguration(
                request: CreateInstanceAccessControlAttributeConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
            ] =
              proxy(CreateInstanceAccessControlAttributeConfiguration, request)
            def listPermissionSetsProvisionedToAccount(
                request: ListPermissionSetsProvisionedToAccountRequest
            ): ZStream[Any, AwsError, PermissionSetArn] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListPermissionSetsProvisionedToAccount, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listPermissionSetsProvisionedToAccountPaginated(
                request: ListPermissionSetsProvisionedToAccountRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse.ReadOnly
            ] = proxy(ListPermissionSetsProvisionedToAccountPaginated, request)
            def putInlinePolicyToPermissionSet(
                request: PutInlinePolicyToPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.PutInlinePolicyToPermissionSetResponse.ReadOnly
            ] = proxy(PutInlinePolicyToPermissionSet, request)
            def listCustomerManagedPolicyReferencesInPermissionSet(
                request: ListCustomerManagedPolicyReferencesInPermissionSetRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(
                    ListCustomerManagedPolicyReferencesInPermissionSet,
                    request
                  )
                }
                .getOrThrowFiberFailure()
            }
            def listCustomerManagedPolicyReferencesInPermissionSetPaginated(
                request: ListCustomerManagedPolicyReferencesInPermissionSetRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse.ReadOnly
            ] = proxy(
              ListCustomerManagedPolicyReferencesInPermissionSetPaginated,
              request
            )
            def listAccountAssignments(
                request: ListAccountAssignmentsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.ssoadmin.model.AccountAssignment.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAccountAssignments, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAccountAssignmentsPaginated(
                request: ListAccountAssignmentsRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.ListAccountAssignmentsResponse.ReadOnly
            ] = proxy(ListAccountAssignmentsPaginated, request)
            def deleteAccountAssignment(
                request: DeleteAccountAssignmentRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly
            ] = proxy(DeleteAccountAssignment, request)
            def updateInstanceAccessControlAttributeConfiguration(
                request: UpdateInstanceAccessControlAttributeConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse.ReadOnly
            ] =
              proxy(UpdateInstanceAccessControlAttributeConfiguration, request)
          }
        }
      }
    }
  }
}
