package zio.aws.ssoadmin
import zio.prelude.Subtype
import zio.aws.ssoadmin.model.primitives.{
  TagKey,
  PermissionSetArn,
  AccountId,
  AccessControlAttributeValueSource
}
import java.time.Instant
import zio.aws.ssoadmin.model.primitives.TagValue.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AccessControlAttributeKey extends Subtype[String]
    type AccessControlAttributeKey =
      zio.aws.ssoadmin.model.primitives.AccessControlAttributeKey.Type
    object AccessControlAttributeValueSource extends Subtype[String]
    type AccessControlAttributeValueSource =
      zio.aws.ssoadmin.model.primitives.AccessControlAttributeValueSource.Type
    object AccountId extends Subtype[String]
    type AccountId = zio.aws.ssoadmin.model.primitives.AccountId.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.ssoadmin.model.primitives.Date.Type
    object Duration extends Subtype[String]
    type Duration = zio.aws.ssoadmin.model.primitives.Duration.Type
    object GeneralArn extends Subtype[String]
    type GeneralArn = zio.aws.ssoadmin.model.primitives.GeneralArn.Type
    object Id extends Subtype[String]
    type Id = zio.aws.ssoadmin.model.primitives.Id.Type
    object InstanceAccessControlAttributeConfigurationStatusReason
        extends Subtype[String]
    type InstanceAccessControlAttributeConfigurationStatusReason =
      zio.aws.ssoadmin.model.primitives.InstanceAccessControlAttributeConfigurationStatusReason.Type
    object InstanceArn extends Subtype[String]
    type InstanceArn = zio.aws.ssoadmin.model.primitives.InstanceArn.Type
    object ManagedPolicyArn extends Subtype[String]
    type ManagedPolicyArn =
      zio.aws.ssoadmin.model.primitives.ManagedPolicyArn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.ssoadmin.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.ssoadmin.model.primitives.Name.Type
    object PermissionSetArn extends Subtype[String]
    type PermissionSetArn =
      zio.aws.ssoadmin.model.primitives.PermissionSetArn.Type
    object PermissionSetDescription extends Subtype[String]
    type PermissionSetDescription =
      zio.aws.ssoadmin.model.primitives.PermissionSetDescription.Type
    object PermissionSetName extends Subtype[String]
    type PermissionSetName =
      zio.aws.ssoadmin.model.primitives.PermissionSetName.Type
    object PermissionSetPolicyDocument extends Subtype[String]
    type PermissionSetPolicyDocument =
      zio.aws.ssoadmin.model.primitives.PermissionSetPolicyDocument.Type
    object PrincipalId extends Subtype[String]
    type PrincipalId = zio.aws.ssoadmin.model.primitives.PrincipalId.Type
    object Reason extends Subtype[String]
    type Reason = zio.aws.ssoadmin.model.primitives.Reason.Type
    object RelayState extends Subtype[String]
    type RelayState = zio.aws.ssoadmin.model.primitives.RelayState.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.ssoadmin.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.ssoadmin.model.primitives.TagValue.Type
    object TargetId extends Subtype[String]
    type TargetId = zio.aws.ssoadmin.model.primitives.TargetId.Type
    object Token extends Subtype[String]
    type Token = zio.aws.ssoadmin.model.primitives.Token.Type
    object UUId extends Subtype[String]
    type UUId = zio.aws.ssoadmin.model.primitives.UUId.Type
  }
  type AccessControlAttributeList =
    List[zio.aws.ssoadmin.model.AccessControlAttribute]
  type AccessControlAttributeValueSourceList =
    List[AccessControlAttributeValueSource]
  type AccountAssignmentList = List[zio.aws.ssoadmin.model.AccountAssignment]
  type AccountAssignmentOperationStatusList =
    List[zio.aws.ssoadmin.model.AccountAssignmentOperationStatusMetadata]
  type AccountList = List[AccountId]
  type AttachedManagedPolicyList =
    List[zio.aws.ssoadmin.model.AttachedManagedPolicy]
  type InstanceList = List[zio.aws.ssoadmin.model.InstanceMetadata]
  type PermissionSetList = List[PermissionSetArn]
  type PermissionSetProvisioningStatusList =
    List[zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.ssoadmin.model.Tag]
}
