package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class InstanceAccessControlAttributeConfiguration(
    accessControlAttributes: Iterable[
      zio.aws.ssoadmin.model.AccessControlAttribute
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.InstanceAccessControlAttributeConfiguration = {
    import InstanceAccessControlAttributeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.InstanceAccessControlAttributeConfiguration
      .builder()
      .accessControlAttributes(accessControlAttributes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly =
    zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
      .wrap(buildAwsValue())
}
object InstanceAccessControlAttributeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.InstanceAccessControlAttributeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration =
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration(
        accessControlAttributes.map { item =>
          item.asEditable
        }
      )
    def accessControlAttributes
        : List[zio.aws.ssoadmin.model.AccessControlAttribute.ReadOnly]
    def getAccessControlAttributes: ZIO[Any, Nothing, List[
      zio.aws.ssoadmin.model.AccessControlAttribute.ReadOnly
    ]] = ZIO.succeed(accessControlAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.InstanceAccessControlAttributeConfiguration
  ) extends zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly {
    override val accessControlAttributes
        : List[zio.aws.ssoadmin.model.AccessControlAttribute.ReadOnly] = impl
      .accessControlAttributes()
      .asScala
      .map { item =>
        zio.aws.ssoadmin.model.AccessControlAttribute.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.InstanceAccessControlAttributeConfiguration
  ): zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly =
    new Wrapper(impl)
}
