package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{UUId, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class DescribePermissionSetProvisioningStatusRequest(
    instanceArn: InstanceArn,
    provisionPermissionSetRequestId: UUId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest = {
    import DescribePermissionSetProvisioningStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .provisionPermissionSetRequestId(
        UUId.unwrap(provisionPermissionSetRequestId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest.ReadOnly =
    zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest
      .wrap(buildAwsValue())
}
object DescribePermissionSetProvisioningStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest =
      zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest(
        instanceArn,
        provisionPermissionSetRequestId
      )
    def instanceArn: InstanceArn
    def provisionPermissionSetRequestId: UUId
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getProvisionPermissionSetRequestId: ZIO[Any, Nothing, UUId] =
      ZIO.succeed(provisionPermissionSetRequestId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest
  ) extends zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val provisionPermissionSetRequestId: UUId =
      zio.aws.ssoadmin.model.primitives
        .UUId(impl.provisionPermissionSetRequestId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest
  ): zio.aws.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest.ReadOnly =
    new Wrapper(impl)
}
