package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.InstanceArn
import scala.jdk.CollectionConverters.*
final case class UpdateInstanceAccessControlAttributeConfigurationRequest(
    instanceArn: InstanceArn,
    instanceAccessControlAttributeConfiguration: zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest = {
    import UpdateInstanceAccessControlAttributeConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .instanceAccessControlAttributeConfiguration(
        instanceAccessControlAttributeConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateInstanceAccessControlAttributeConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest =
      zio.aws.ssoadmin.model
        .UpdateInstanceAccessControlAttributeConfigurationRequest(
          instanceArn,
          instanceAccessControlAttributeConfiguration.asEditable
        )
    def instanceArn: InstanceArn
    def instanceAccessControlAttributeConfiguration
        : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getInstanceAccessControlAttributeConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly
    ] = ZIO.succeed(instanceAccessControlAttributeConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest
  ) extends zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val instanceAccessControlAttributeConfiguration
        : zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration.ReadOnly =
      zio.aws.ssoadmin.model.InstanceAccessControlAttributeConfiguration
        .wrap(impl.instanceAccessControlAttributeConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest
  ): zio.aws.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
