package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{Date, UUId}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PermissionSetProvisioningStatusMetadata(
    status: Option[zio.aws.ssoadmin.model.StatusValues] = None,
    requestId: Option[UUId] = None,
    createdDate: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata = {
    import PermissionSetProvisioningStatusMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        requestId.map(value => UUId.unwrap(value): java.lang.String)
      )(_.requestId)
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly =
    zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata
      .wrap(buildAwsValue())
}
object PermissionSetProvisioningStatusMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata =
      zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata(
        status.map(value => value),
        requestId.map(value => value),
        createdDate.map(value => value)
      )
    def status: Option[zio.aws.ssoadmin.model.StatusValues]
    def requestId: Option[UUId]
    def createdDate: Option[Date]
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
    def getRequestId: ZIO[Any, AwsError, UUId] =
      AwsError.unwrapOptionField("requestId", requestId)
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata
  ) extends zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly {
    override val status: Option[zio.aws.ssoadmin.model.StatusValues] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
    override val requestId: Option[UUId] = scala
      .Option(impl.requestId())
      .map(value => zio.aws.ssoadmin.model.primitives.UUId(value))
    override val createdDate: Option[Date] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata
  ): zio.aws.ssoadmin.model.PermissionSetProvisioningStatusMetadata.ReadOnly =
    new Wrapper(impl)
}
