package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  Date,
  PermissionSetName,
  RelayState,
  PermissionSetArn,
  Duration,
  PermissionSetDescription
}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PermissionSet(
    name: Option[PermissionSetName] = None,
    permissionSetArn: Option[PermissionSetArn] = None,
    description: Option[PermissionSetDescription] = None,
    createdDate: Option[Date] = None,
    sessionDuration: Option[Duration] = None,
    relayState: Option[RelayState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.PermissionSet = {
    import PermissionSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.PermissionSet
      .builder()
      .optionallyWith(
        name.map(value => PermissionSetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        permissionSetArn.map(value =>
          PermissionSetArn.unwrap(value): java.lang.String
        )
      )(_.permissionSetArn)
      .optionallyWith(
        description.map(value =>
          PermissionSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdDate.map(value => Date.unwrap(value): Instant))(
        _.createdDate
      )
      .optionallyWith(
        sessionDuration.map(value => Duration.unwrap(value): java.lang.String)
      )(_.sessionDuration)
      .optionallyWith(
        relayState.map(value => RelayState.unwrap(value): java.lang.String)
      )(_.relayState)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.PermissionSet.ReadOnly =
    zio.aws.ssoadmin.model.PermissionSet.wrap(buildAwsValue())
}
object PermissionSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.PermissionSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.PermissionSet =
      zio.aws.ssoadmin.model.PermissionSet(
        name.map(value => value),
        permissionSetArn.map(value => value),
        description.map(value => value),
        createdDate.map(value => value),
        sessionDuration.map(value => value),
        relayState.map(value => value)
      )
    def name: Option[PermissionSetName]
    def permissionSetArn: Option[PermissionSetArn]
    def description: Option[PermissionSetDescription]
    def createdDate: Option[Date]
    def sessionDuration: Option[Duration]
    def relayState: Option[RelayState]
    def getName: ZIO[Any, AwsError, PermissionSetName] =
      AwsError.unwrapOptionField("name", name)
    def getPermissionSetArn: ZIO[Any, AwsError, PermissionSetArn] =
      AwsError.unwrapOptionField("permissionSetArn", permissionSetArn)
    def getDescription: ZIO[Any, AwsError, PermissionSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getSessionDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("sessionDuration", sessionDuration)
    def getRelayState: ZIO[Any, AwsError, RelayState] =
      AwsError.unwrapOptionField("relayState", relayState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSet
  ) extends zio.aws.ssoadmin.model.PermissionSet.ReadOnly {
    override val name: Option[PermissionSetName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetName(value))
    override val permissionSetArn: Option[PermissionSetArn] = scala
      .Option(impl.permissionSetArn())
      .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetArn(value))
    override val description: Option[PermissionSetDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssoadmin.model.primitives.PermissionSetDescription(value)
      )
    override val createdDate: Option[Date] = scala
      .Option(impl.createdDate())
      .map(value => zio.aws.ssoadmin.model.primitives.Date(value))
    override val sessionDuration: Option[Duration] = scala
      .Option(impl.sessionDuration())
      .map(value => zio.aws.ssoadmin.model.primitives.Duration(value))
    override val relayState: Option[RelayState] = scala
      .Option(impl.relayState())
      .map(value => zio.aws.ssoadmin.model.primitives.RelayState(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.PermissionSet
  ): zio.aws.ssoadmin.model.PermissionSet.ReadOnly = new Wrapper(impl)
}
