package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{GeneralArn, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    instanceArn: InstanceArn,
    resourceArn: GeneralArn,
    tags: Iterable[zio.aws.ssoadmin.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .resourceArn(GeneralArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.TagResourceRequest.ReadOnly =
    zio.aws.ssoadmin.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.TagResourceRequest =
      zio.aws.ssoadmin.model.TagResourceRequest(
        instanceArn,
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def instanceArn: InstanceArn
    def resourceArn: GeneralArn
    def tags: List[zio.aws.ssoadmin.model.Tag.ReadOnly]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getResourceArn: ZIO[Any, Nothing, GeneralArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.ssoadmin.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest
  ) extends zio.aws.ssoadmin.model.TagResourceRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val resourceArn: GeneralArn =
      zio.aws.ssoadmin.model.primitives.GeneralArn(impl.resourceArn())
    override val tags: List[zio.aws.ssoadmin.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.ssoadmin.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest
  ): zio.aws.ssoadmin.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
