package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  InstanceArn,
  RelayState,
  PermissionSetArn,
  Duration,
  PermissionSetDescription
}
import scala.jdk.CollectionConverters.*
final case class UpdatePermissionSetRequest(
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    description: Option[PermissionSetDescription] = None,
    sessionDuration: Option[Duration] = None,
    relayState: Option[RelayState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest = {
    import UpdatePermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .optionallyWith(
        description.map(value =>
          PermissionSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        sessionDuration.map(value => Duration.unwrap(value): java.lang.String)
      )(_.sessionDuration)
      .optionallyWith(
        relayState.map(value => RelayState.unwrap(value): java.lang.String)
      )(_.relayState)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.UpdatePermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.UpdatePermissionSetRequest.wrap(buildAwsValue())
}
object UpdatePermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.UpdatePermissionSetRequest =
      zio.aws.ssoadmin.model.UpdatePermissionSetRequest(
        instanceArn,
        permissionSetArn,
        description.map(value => value),
        sessionDuration.map(value => value),
        relayState.map(value => value)
      )
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def description: Option[PermissionSetDescription]
    def sessionDuration: Option[Duration]
    def relayState: Option[RelayState]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getDescription: ZIO[Any, AwsError, PermissionSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getSessionDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("sessionDuration", sessionDuration)
    def getRelayState: ZIO[Any, AwsError, RelayState] =
      AwsError.unwrapOptionField("relayState", relayState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
  ) extends zio.aws.ssoadmin.model.UpdatePermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val description: Option[PermissionSetDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssoadmin.model.primitives.PermissionSetDescription(value)
      )
    override val sessionDuration: Option[Duration] = scala
      .Option(impl.sessionDuration())
      .map(value => zio.aws.ssoadmin.model.primitives.Duration(value))
    override val relayState: Option[RelayState] = scala
      .Option(impl.relayState())
      .map(value => zio.aws.ssoadmin.model.primitives.RelayState(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
  ): zio.aws.ssoadmin.model.UpdatePermissionSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
