package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  InstanceArn,
  PermissionSetName,
  RelayState,
  Duration,
  PermissionSetDescription
}
import scala.jdk.CollectionConverters.*
final case class CreatePermissionSetRequest(
    name: PermissionSetName,
    description: Option[PermissionSetDescription] = None,
    instanceArn: InstanceArn,
    sessionDuration: Option[Duration] = None,
    relayState: Option[RelayState] = None,
    tags: Option[Iterable[zio.aws.ssoadmin.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest = {
    import CreatePermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
      .builder()
      .name(PermissionSetName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          PermissionSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .optionallyWith(
        sessionDuration.map(value => Duration.unwrap(value): java.lang.String)
      )(_.sessionDuration)
      .optionallyWith(
        relayState.map(value => RelayState.unwrap(value): java.lang.String)
      )(_.relayState)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.CreatePermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.CreatePermissionSetRequest.wrap(buildAwsValue())
}
object CreatePermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.CreatePermissionSetRequest =
      zio.aws.ssoadmin.model.CreatePermissionSetRequest(
        name,
        description.map(value => value),
        instanceArn,
        sessionDuration.map(value => value),
        relayState.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: PermissionSetName
    def description: Option[PermissionSetDescription]
    def instanceArn: InstanceArn
    def sessionDuration: Option[Duration]
    def relayState: Option[RelayState]
    def tags: Option[List[zio.aws.ssoadmin.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, PermissionSetName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, PermissionSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getSessionDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("sessionDuration", sessionDuration)
    def getRelayState: ZIO[Any, AwsError, RelayState] =
      AwsError.unwrapOptionField("relayState", relayState)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssoadmin.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
  ) extends zio.aws.ssoadmin.model.CreatePermissionSetRequest.ReadOnly {
    override val name: PermissionSetName =
      zio.aws.ssoadmin.model.primitives.PermissionSetName(impl.name())
    override val description: Option[PermissionSetDescription] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssoadmin.model.primitives.PermissionSetDescription(value)
      )
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val sessionDuration: Option[Duration] = scala
      .Option(impl.sessionDuration())
      .map(value => zio.aws.ssoadmin.model.primitives.Duration(value))
    override val relayState: Option[RelayState] = scala
      .Option(impl.relayState())
      .map(value => zio.aws.ssoadmin.model.primitives.RelayState(value))
    override val tags: Option[List[zio.aws.ssoadmin.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
  ): zio.aws.ssoadmin.model.CreatePermissionSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
