package zio.aws.ssoadmin.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{MaxResults, Token, InstanceArn}
import scala.jdk.CollectionConverters.*
final case class ListPermissionSetsRequest(
    instanceArn: InstanceArn,
    nextToken: Option[Token] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest = {
    import ListPermissionSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.ListPermissionSetsRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetsRequest.wrap(buildAwsValue())
}
object ListPermissionSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListPermissionSetsRequest =
      zio.aws.ssoadmin.model.ListPermissionSetsRequest(
        instanceArn,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def instanceArn: InstanceArn
    def nextToken: Option[Token]
    def maxResults: Option[MaxResults]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest
  ) extends zio.aws.ssoadmin.model.ListPermissionSetsRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest
  ): zio.aws.ssoadmin.model.ListPermissionSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
