package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreatePermissionSetResponse(
    permissionSet: Option[zio.aws.ssoadmin.model.PermissionSet] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse = {
    import CreatePermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse
      .builder()
      .optionallyWith(permissionSet.map(value => value.buildAwsValue()))(
        _.permissionSet
      )
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.CreatePermissionSetResponse.wrap(buildAwsValue())
}
object CreatePermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.CreatePermissionSetResponse =
      zio.aws.ssoadmin.model.CreatePermissionSetResponse(
        permissionSet.map(value => value.asEditable)
      )
    def permissionSet: Option[zio.aws.ssoadmin.model.PermissionSet.ReadOnly]
    def getPermissionSet
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.PermissionSet.ReadOnly] =
      AwsError.unwrapOptionField("permissionSet", permissionSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse
  ) extends zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly {
    override val permissionSet
        : Option[zio.aws.ssoadmin.model.PermissionSet.ReadOnly] = scala
      .Option(impl.permissionSet())
      .map(value => zio.aws.ssoadmin.model.PermissionSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse
  ): zio.aws.ssoadmin.model.CreatePermissionSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
