package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Option[Iterable[zio.aws.ssoadmin.model.Tag]] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.ListTagsForResourceResponse =
      zio.aws.ssoadmin.model.ListTagsForResourceResponse(
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def tags: Option[List[zio.aws.ssoadmin.model.Tag.ReadOnly]]
    def nextToken: Option[Token]
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssoadmin.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
  ) extends zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Option[List[zio.aws.ssoadmin.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.Tag.wrap(item)
        }.toList
      )
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse
  ): zio.aws.ssoadmin.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
