package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  PrincipalId,
  PermissionSetArn,
  AccountId
}
import scala.jdk.CollectionConverters.*
final case class AccountAssignment(
    accountId: Option[AccountId] = None,
    permissionSetArn: Option[PermissionSetArn] = None,
    principalType: Option[zio.aws.ssoadmin.model.PrincipalType] = None,
    principalId: Option[PrincipalId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AccountAssignment = {
    import AccountAssignment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignment
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        permissionSetArn.map(value =>
          PermissionSetArn.unwrap(value): java.lang.String
        )
      )(_.permissionSetArn)
      .optionallyWith(principalType.map(value => value.unwrap))(_.principalType)
      .optionallyWith(
        principalId.map(value => PrincipalId.unwrap(value): java.lang.String)
      )(_.principalId)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.AccountAssignment.ReadOnly =
    zio.aws.ssoadmin.model.AccountAssignment.wrap(buildAwsValue())
}
object AccountAssignment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AccountAssignment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.AccountAssignment =
      zio.aws.ssoadmin.model.AccountAssignment(
        accountId.map(value => value),
        permissionSetArn.map(value => value),
        principalType.map(value => value),
        principalId.map(value => value)
      )
    def accountId: Option[AccountId]
    def permissionSetArn: Option[PermissionSetArn]
    def principalType: Option[zio.aws.ssoadmin.model.PrincipalType]
    def principalId: Option[PrincipalId]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getPermissionSetArn: ZIO[Any, AwsError, PermissionSetArn] =
      AwsError.unwrapOptionField("permissionSetArn", permissionSetArn)
    def getPrincipalType
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.PrincipalType] =
      AwsError.unwrapOptionField("principalType", principalType)
    def getPrincipalId: ZIO[Any, AwsError, PrincipalId] =
      AwsError.unwrapOptionField("principalId", principalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignment
  ) extends zio.aws.ssoadmin.model.AccountAssignment.ReadOnly {
    override val accountId: Option[AccountId] = scala
      .Option(impl.accountId())
      .map(value => zio.aws.ssoadmin.model.primitives.AccountId(value))
    override val permissionSetArn: Option[PermissionSetArn] = scala
      .Option(impl.permissionSetArn())
      .map(value => zio.aws.ssoadmin.model.primitives.PermissionSetArn(value))
    override val principalType: Option[zio.aws.ssoadmin.model.PrincipalType] =
      scala
        .Option(impl.principalType())
        .map(value => zio.aws.ssoadmin.model.PrincipalType.wrap(value))
    override val principalId: Option[PrincipalId] = scala
      .Option(impl.principalId())
      .map(value => zio.aws.ssoadmin.model.primitives.PrincipalId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AccountAssignment
  ): zio.aws.ssoadmin.model.AccountAssignment.ReadOnly = new Wrapper(impl)
}
