package zio.aws.ssoadmin.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  Token,
  MaxResults,
  AccountId,
  InstanceArn
}
import scala.jdk.CollectionConverters.*
final case class ListPermissionSetsProvisionedToAccountRequest(
    instanceArn: InstanceArn,
    accountId: AccountId,
    provisioningStatus: Option[zio.aws.ssoadmin.model.ProvisioningStatus] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[Token] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest = {
    import ListPermissionSetsProvisionedToAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .accountId(AccountId.unwrap(accountId): java.lang.String)
      .optionallyWith(provisioningStatus.map(value => value.unwrap))(
        _.provisioningStatus
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.ReadOnly =
    zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
      .wrap(buildAwsValue())
}
object ListPermissionSetsProvisionedToAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest =
      zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest(
        instanceArn,
        accountId,
        provisioningStatus.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def instanceArn: InstanceArn
    def accountId: AccountId
    def provisioningStatus: Option[zio.aws.ssoadmin.model.ProvisioningStatus]
    def maxResults: Option[MaxResults]
    def nextToken: Option[Token]
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getAccountId: ZIO[Any, Nothing, AccountId] = ZIO.succeed(accountId)
    def getProvisioningStatus
        : ZIO[Any, AwsError, zio.aws.ssoadmin.model.ProvisioningStatus] =
      AwsError.unwrapOptionField("provisioningStatus", provisioningStatus)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
  ) extends zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val accountId: AccountId =
      zio.aws.ssoadmin.model.primitives.AccountId(impl.accountId())
    override val provisioningStatus
        : Option[zio.aws.ssoadmin.model.ProvisioningStatus] = scala
      .Option(impl.provisioningStatus())
      .map(value => zio.aws.ssoadmin.model.ProvisioningStatus.wrap(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssoadmin.model.primitives.MaxResults(value))
    override val nextToken: Option[Token] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
  ): zio.aws.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest.ReadOnly =
    new Wrapper(impl)
}
