package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteAccountAssignmentResponse(
    accountAssignmentDeletionStatus: Option[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse = {
    import DeleteAccountAssignmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse
      .builder()
      .optionallyWith(
        accountAssignmentDeletionStatus.map(value => value.buildAwsValue())
      )(_.accountAssignmentDeletionStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly =
    zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.wrap(buildAwsValue())
}
object DeleteAccountAssignmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse =
      zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse(
        accountAssignmentDeletionStatus.map(value => value.asEditable)
      )
    def accountAssignmentDeletionStatus: Option[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ]
    def getAccountAssignmentDeletionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accountAssignmentDeletionStatus",
      accountAssignmentDeletionStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse
  ) extends zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly {
    override val accountAssignmentDeletionStatus: Option[
      zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.ReadOnly
    ] = scala
      .Option(impl.accountAssignmentDeletionStatus())
      .map(value =>
        zio.aws.ssoadmin.model.AccountAssignmentOperationStatus.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse
  ): zio.aws.ssoadmin.model.DeleteAccountAssignmentResponse.ReadOnly =
    new Wrapper(impl)
}
