package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  InstanceArn,
  RelayState,
  PermissionSetArn,
  Duration,
  PermissionSetDescription
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePermissionSetRequest(
    description: Optional[PermissionSetDescription] = Optional.Absent,
    instanceArn: InstanceArn,
    permissionSetArn: PermissionSetArn,
    relayState: Optional[RelayState] = Optional.Absent,
    sessionDuration: Optional[Duration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest = {
    import UpdatePermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          PermissionSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .optionallyWith(
        relayState.map(value => RelayState.unwrap(value): java.lang.String)
      )(_.relayState)
      .optionallyWith(
        sessionDuration.map(value => Duration.unwrap(value): java.lang.String)
      )(_.sessionDuration)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.UpdatePermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.UpdatePermissionSetRequest.wrap(buildAwsValue())
}
object UpdatePermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.UpdatePermissionSetRequest =
      zio.aws.ssoadmin.model.UpdatePermissionSetRequest(
        description.map(value => value),
        instanceArn,
        permissionSetArn,
        relayState.map(value => value),
        sessionDuration.map(value => value)
      )
    def description: Optional[PermissionSetDescription]
    def instanceArn: InstanceArn
    def permissionSetArn: PermissionSetArn
    def relayState: Optional[RelayState]
    def sessionDuration: Optional[Duration]
    def getDescription: ZIO[Any, AwsError, PermissionSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
    def getRelayState: ZIO[Any, AwsError, RelayState] =
      AwsError.unwrapOptionField("relayState", relayState)
    def getSessionDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("sessionDuration", sessionDuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
  ) extends zio.aws.ssoadmin.model.UpdatePermissionSetRequest.ReadOnly {
    override val description: Optional[PermissionSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssoadmin.model.primitives.PermissionSetDescription(value)
        )
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
    override val relayState: Optional[RelayState] = zio.aws.core.internal
      .optionalFromNullable(impl.relayState())
      .map(value => zio.aws.ssoadmin.model.primitives.RelayState(value))
    override val sessionDuration: Optional[Duration] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionDuration())
      .map(value => zio.aws.ssoadmin.model.primitives.Duration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest
  ): zio.aws.ssoadmin.model.UpdatePermissionSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
