package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{
  InstanceArn,
  PermissionSetName,
  RelayState,
  Duration,
  PermissionSetDescription
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePermissionSetRequest(
    description: Optional[PermissionSetDescription] = Optional.Absent,
    instanceArn: InstanceArn,
    name: PermissionSetName,
    relayState: Optional[RelayState] = Optional.Absent,
    sessionDuration: Optional[Duration] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssoadmin.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest = {
    import CreatePermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
      .builder()
      .optionallyWith(
        description.map(value =>
          PermissionSetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .name(PermissionSetName.unwrap(name): java.lang.String)
      .optionallyWith(
        relayState.map(value => RelayState.unwrap(value): java.lang.String)
      )(_.relayState)
      .optionallyWith(
        sessionDuration.map(value => Duration.unwrap(value): java.lang.String)
      )(_.sessionDuration)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.CreatePermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.CreatePermissionSetRequest.wrap(buildAwsValue())
}
object CreatePermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.CreatePermissionSetRequest =
      zio.aws.ssoadmin.model.CreatePermissionSetRequest(
        description.map(value => value),
        instanceArn,
        name,
        relayState.map(value => value),
        sessionDuration.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def description: Optional[PermissionSetDescription]
    def instanceArn: InstanceArn
    def name: PermissionSetName
    def relayState: Optional[RelayState]
    def sessionDuration: Optional[Duration]
    def tags: Optional[List[zio.aws.ssoadmin.model.Tag.ReadOnly]]
    def getDescription: ZIO[Any, AwsError, PermissionSetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getName: ZIO[Any, Nothing, PermissionSetName] = ZIO.succeed(name)
    def getRelayState: ZIO[Any, AwsError, RelayState] =
      AwsError.unwrapOptionField("relayState", relayState)
    def getSessionDuration: ZIO[Any, AwsError, Duration] =
      AwsError.unwrapOptionField("sessionDuration", sessionDuration)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssoadmin.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
  ) extends zio.aws.ssoadmin.model.CreatePermissionSetRequest.ReadOnly {
    override val description: Optional[PermissionSetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssoadmin.model.primitives.PermissionSetDescription(value)
        )
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val name: PermissionSetName =
      zio.aws.ssoadmin.model.primitives.PermissionSetName(impl.name())
    override val relayState: Optional[RelayState] = zio.aws.core.internal
      .optionalFromNullable(impl.relayState())
      .map(value => zio.aws.ssoadmin.model.primitives.RelayState(value))
    override val sessionDuration: Optional[Duration] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionDuration())
      .map(value => zio.aws.ssoadmin.model.primitives.Duration(value))
    override val tags: Optional[List[zio.aws.ssoadmin.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssoadmin.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest
  ): zio.aws.ssoadmin.model.CreatePermissionSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
