package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ssoadmin.model.primitives.{
  PermissionSetArn,
  ManagedPolicyArn,
  InstanceArn
}
import scala.jdk.CollectionConverters._
final case class AttachManagedPolicyToPermissionSetRequest(
    instanceArn: InstanceArn,
    managedPolicyArn: ManagedPolicyArn,
    permissionSetArn: PermissionSetArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest = {
    import AttachManagedPolicyToPermissionSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest
      .builder()
      .instanceArn(InstanceArn.unwrap(instanceArn): java.lang.String)
      .managedPolicyArn(
        ManagedPolicyArn.unwrap(managedPolicyArn): java.lang.String
      )
      .permissionSetArn(
        PermissionSetArn.unwrap(permissionSetArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest.ReadOnly =
    zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest
      .wrap(buildAwsValue())
}
object AttachManagedPolicyToPermissionSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest =
      zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest(
        instanceArn,
        managedPolicyArn,
        permissionSetArn
      )
    def instanceArn: InstanceArn
    def managedPolicyArn: ManagedPolicyArn
    def permissionSetArn: PermissionSetArn
    def getInstanceArn: ZIO[Any, Nothing, InstanceArn] =
      ZIO.succeed(instanceArn)
    def getManagedPolicyArn: ZIO[Any, Nothing, ManagedPolicyArn] =
      ZIO.succeed(managedPolicyArn)
    def getPermissionSetArn: ZIO[Any, Nothing, PermissionSetArn] =
      ZIO.succeed(permissionSetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest
  ) extends zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest.ReadOnly {
    override val instanceArn: InstanceArn =
      zio.aws.ssoadmin.model.primitives.InstanceArn(impl.instanceArn())
    override val managedPolicyArn: ManagedPolicyArn =
      zio.aws.ssoadmin.model.primitives
        .ManagedPolicyArn(impl.managedPolicyArn())
    override val permissionSetArn: PermissionSetArn =
      zio.aws.ssoadmin.model.primitives
        .PermissionSetArn(impl.permissionSetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest
  ): zio.aws.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest.ReadOnly =
    new Wrapper(impl)
}
