package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListCustomerManagedPolicyReferencesInPermissionSetResponse(
    customerManagedPolicyReferences: Optional[
      Iterable[zio.aws.ssoadmin.model.CustomerManagedPolicyReference]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse = {
    import ListCustomerManagedPolicyReferencesInPermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse
      .builder()
      .optionallyWith(
        customerManagedPolicyReferences.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customerManagedPolicyReferences)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse
      .wrap(buildAwsValue())
}
object ListCustomerManagedPolicyReferencesInPermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse =
      zio.aws.ssoadmin.model
        .ListCustomerManagedPolicyReferencesInPermissionSetResponse(
          customerManagedPolicyReferences.map(value =>
            value.map { item =>
              item.asEditable
            }
          ),
          nextToken.map(value => value)
        )
    def customerManagedPolicyReferences: Optional[
      List[zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly]
    ]
    def nextToken: Optional[Token]
    def getCustomerManagedPolicyReferences: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customerManagedPolicyReferences",
      customerManagedPolicyReferences
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse
  ) extends zio.aws.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse.ReadOnly {
    override val customerManagedPolicyReferences: Optional[
      List[zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManagedPolicyReferences())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.CustomerManagedPolicyReference.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse
  ): zio.aws.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
